/* 
 * Copyright 2007 Tatooine Project <http://tatooine.sourceforge.jp/> 
 *  
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *  
 *     http://www.apache.org/licenses/LICENSE-2.0
 *  
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.sf.tatooine.gtx;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/**
 * 固定文言を雑多に定義したインタフェース.
 * <p>
 * @author  Tooru Noda
 * @version 1.0 2007/04/17
 * @since   JDK5.0 Tiger
 */
public class GtxConsts {

	// ここで定義されるものは内部的に使われるもののみとする。
	// 外部公開を前提とするものは別の定義場所を検討すること。
	
	/** 名前空間URI. */
	public static final String NS_URI = "http://tatooine.sourceforge.jp/ns/gtx";
	
	public static final String IF = "if";
	
	public static final String UNLESS = "unless";
	
	public static final String IGNORE = "ignore";
	
	public static final String FOR = "for";
	
	public static final String INDEX = "index";
	
	public static final String STEP = "step";
	
	public static final String INSIDE = "inside";
	
	public static final String INNER_TEXT = "inner-text";
	
	public static final String NULL = "null";
	
	public static final List<String> ATTR_NAMES;
	static {
		List<String> list = new ArrayList<String>();
		list.add(IF);
		list.add(UNLESS);
		list.add(IGNORE);
		list.add(FOR);
		list.add(INDEX);
		list.add(STEP);
		list.add(INSIDE);
		list.add(INNER_TEXT);
		list.add(NULL);
		ATTR_NAMES = Collections.unmodifiableList(list);
	}	
}
