# validate_for_insert, update, delete, save
# validate_value, take_value
# ValidationError - key, object

class TestValidationObject < TapKit::GenericRecord
	attr_accessor :attribute, :validated

	def validate_attribute( value )
		if value == false then
			@validated = true
		end
	end

	def validated?
		@validated
	end
end


class TestValidation < Test::Unit::TestCase
	include TapKit

	def setup
		@app = Application.new((MODELS+[MODEL_TO_ONE]))
		@ec  = @app.create_editing_context
	end

	def test_validation_error
		key     = 'test'
		object  = {:flag => :test}
		error   = ValidationError.new('an error', key, object)
		error.add('an error', key)
		_object = {ValidationError::EXCEPTIONS => []}
		object2 = {ValidationError::EXCEPTIONS => [error]}
		error2  = ValidationError.new('an error', key, object2)

		assert_equal(key, error.key)
		assert_equal(:test, error.object[:flag])
		assert_equal('an error', error.exception_with_key_and_object(key, _object).message)
		assert_equal([error], error2.exceptions)
	end

	def test_validation_error_aggregate
		error  = ValidationError.new
		error2 = ValidationError.new
		error3 = ValidationError.new 'test message'
		errors = [error2, error3]

		assert_equal(error3, ValidationError.aggregate(errors))
	end

	def test_validate_value
		test = TestValidationObject.new
		test.validate_value('attribute', false)
		assert_equal(true, test.validated?)
	end

	def test_validate_take_value_for_keypath
		object = @ec.create 'Book'
		validation = TestValidationObject.new
		object['publisher'] = validation
		object.validate_take_value_for_keypath('publisher.attribute', false)
		assert_equal(true, validation.validated?)
	end


	# attribute - null, read_only, width
	# relation - null
	def test_validate_for_save
		object = @ec.create 'Book'
		entity = object.class_description.entity
		attr_title = entity.attribute 'title'
		attr_publisher = entity.relationship 'publisher'

		# dummy fault handler
		fault = @ec.create 'Publisher'
		fault.turn_into_fault FaultHandler.new
		object['publisher'] = fault

		## attribute
		attr_title.allow_null = true
		attr_title.read_only  = false
		attr_title.width      = 100

		# allow_null
		attr_title.allow_null = false
		assert_raises(ValidationError) { @ec.save }
		attr_title.allow_null = true

		# read_only
		object['title'] = 'test'
		attr_title.read_only = true
		assert_raises(ValidationError) { @ec.save }
		attr_title.read_only  = false

		# width
		attr_title.width = 1
		assert_raises(ValidationError) { @ec.save }
		attr_title.width = 100

		## relationship
		attr_publisher.mandatory = false

		# mandatory
		attr_publisher.mandatory = true
		assert_raises(ValidationError) { @ec.save }
		attr_publisher.mandatory = false
	end

	# the test is in test_description
	# def test_validate_for_delete; end

	def test_validate_read_only_primary_key
		# read value of primary key
		qualifier = Qualifier.format("c_name == 'C_NAME'")
		fetchspec = FetchSpec.new('C', qualifier)
		objects   = @ec.fetch(fetchspec)
		assert_not_nil objects[0]['c_id']

		# insert a new object without validation for primary key
		object = @ec.create 'C'
		object['c_name'] = 'test_c_name'
		
		assert_nothing_thrown do
			@ec.save
		end
	end

end
