class TestRelationshipManipulation < Test::Unit::TestCase
	include TapKit

	def setup
		@app = Application.new MODELS
		@ec  = @app.create_editing_context
	end

	def test_keys_with_validation
		object = @ec.create 'Book'
		assert_raises(RuntimeError) { object.remove_object_from_property(nil, 'dummy') }
	end

	def test_add_object_to_both_sides_of_relationship
	end

	def test_add_object_to_property
		# to-one
		object = @ec.create 'Book'
		object.add_object_to_property('dummy', 'publisher')
		assert_equal('dummy', object['publisher'])

		# to-many
		object = @ec.create 'Publisher'
		object.add_object_to_property('dummy', 'books')
		assert object['books'].include?('dummy')
	end

	def test_remove_object_from_both_sides_of_relationship
		# to-one
		book = @ec.create 'Book'
		publisher = @ec.create 'Publisher'
		book['publisher'] = publisher
		publisher['books'] << book

		book.remove_object_from_both_sides_of_relationship(publisher, 'publisher')
		assert_nil book['publisher']
		assert_equal(false, publisher['books'].include?(book))


		# to-many
		book = @ec.create 'Book'
		publisher = @ec.create 'Publisher'
		book['publisher'] = publisher
		publisher['books'] << book

		publisher.remove_object_from_both_sides_of_relationship(book, 'books')
		assert_nil book['publisher']
		assert_equal(false, publisher['books'].include?(book))
	end

	def test_remove_object_from_property
		# to-one
		object = @ec.create 'Book'
		object['publisher'] = 'dummy'
		object.remove_object_from_property('dummy', 'publisher')
		assert_nil object['publisher']

		# to-many
		object = @ec.create 'Publisher'
		object['books'] << 'dummy'
		object.remove_object_from_property('dummy', 'books')
		assert_equal(false, object['books'].include?('dummy'))
	end
end
