#!/usr/local/bin/ruby

$LOAD_PATH.unshift '../lib'

require 'tapkit'
require 'test/unit'
require 'test/unit/ui/console/testrunner'
require 'test_application'
require 'test_attribute'
require 'test_custom_attribute'
require 'test_date'
require 'test_dbobject'
require 'test_description'
require 'test_editing_context'
require 'test_editing_context_fetch'
require 'test_editing_context_insert'
require 'test_editing_context_delete'
require 'test_editing_context_update'
require 'test_entity'
require 'test_gid'
require 'test_join'
require 'test_keyvaluecoding'
require 'test_compound_key'
require 'test_manipulation'
require 'test_model'
require 'test_qualifier'
require 'test_relationship'
require 'test_sort_ordering'
require 'test_sql_expression'
require 'test_time'
require 'test_timestamp'
require 'test_utilities'
require 'test_validation'


MODEL1 = '../examples/model/single_entity.yaml'
MODEL2 = '../examples/model/relationship_entity.yaml'
MODEL3 = '../examples/model/mapping.yaml'
MODELS = [MODEL1, MODEL2, MODEL3]

MODEL_TO_ONE = '../examples/model/to_one.yaml'
MODEL_FOR_COMPOUND_KEY = '../examples/model/employee2.yaml'
MODELS2 = [MODEL_TO_ONE, MODEL_FOR_COMPOUND_KEY]

ALL_MODELS = (MODELS + MODELS2)


suite = Test::Unit::TestSuite.new 'TapKit TestSuite'
level = 2

ObjectSpace.each_object(Class) do |klass|
	if (klass.ancestors.include?(Test::Unit::TestCase)) and \
		(klass != Test::Unit::TestCase) then
		suite << klass.suite
	end
end

Test::Unit::UI::Console::TestRunner.run(suite, level)



# clear test data
def delete( ec, fetchspec )
	print "Delete test data for '#{fetchspec.entity_name}' ... "
	begin
		objects = ec.fetch fetchspec
		objects.each { |object| ec.delete(object) }
		ec.save
	rescue Exception => e
		puts "FAILED (#{e.message} #{e.backtrace})"
		false
	else
		puts 'OK'
		true
	end
end

include TapKit

app = Application.new ALL_MODELS
#app.log_options[:sql] = true
ec = app.create_editing_context
q_title = Qualifier.format "title like 'test*'"
q_name = Qualifier.format "name like 'test*'"

fetch_cd = FetchSpec.new('cd', q_title)
fetch_book = FetchSpec.new('Book', q_title)
fetch_publisher = FetchSpec.new('Publisher', q_name)
fetch_company = FetchSpec.new('Company', q_name)
fetch_employee = FetchSpec.new('Employee', q_name)
fetch_project = FetchSpec.new('Project', q_name)
fetch_employee_project = FetchSpec.new 'EmployeeProject'
fetch_c = FetchSpec.new('C', Qualifier.format("c_name like 'test*'"))
fetch_mapping = FetchSpec.new('Mapping', Qualifier.format("string like 'test*'"))

is_deleted = []
puts
is_deleted << delete(ec, fetch_cd)
is_deleted << delete(app.create_editing_context, fetch_book)
is_deleted << delete(ec, fetch_publisher)
is_deleted << delete(ec, fetch_company)
is_deleted << delete(ec, fetch_employee)
is_deleted << delete(ec, fetch_project)
is_deleted << delete(ec, fetch_employee_project)
is_deleted << delete(ec, fetch_c)
is_deleted << delete(ec, fetch_mapping)

if is_deleted.include? false then
	puts "Can't complete deleting."
else
	puts "Complete deleting all test data."
end
