module TapKit

	class ValidationError < StandardError
		attr_reader :key, :object

		EXCEPTIONS = :exceptions

		class << self
			def aggregate( exceptions )
				exceptions.each do |ex|
					unless ex.message.empty? then
						return ex
					end
				end
			end
		end

		def initialize( message = '', key = nil, object = {} )
			super message
			@key = key
			@object = object
			unless Array === @object[EXCEPTIONS] then
				@object[EXCEPTIONS] = []
			end
		end

		def add( message = '', key = nil, object = {} )
			exception = ValidationError.new(message, key, object)
			exceptions << exception
		end

		def exception_with_key_and_object( key, object )
			exceptions.each do |ex|
				if (ex.key == key) and (ex.object == object) then
					return ex
				end
			end
			nil
		end

		def exceptions
			@object[EXCEPTIONS]
		end

		def value
			@object[key]
		end
	end


	module Validation
		def validate_value( key, value )
			method = "validate_#{key}"
			if respond_to? method then
				__send__(method, value)
			end
		end

		def validate_take_value_for_keypath( keypath, value )
			paths  = keypath.split '.'
			object = self
			paths.each_with_index do |path, index|
				if (index + 1) == paths.size then
					object.validate_value(path, value)
				else
					object = object[path]
				end
			end
		end

		def validate_for_insert
			validate_for_save
		end

		def validate_for_update
			validate_for_save
		end

		def validate_for_delete
			@class_description.validate_object_for_delete self
		end

		def validate_for_save
			@class_description.validate_object_for_save self
		end
	end

end
