class BookListDatabase
	include TapKit

	def initialize( model )
		@app = Application.new model
		@ec  = @app.create_editing_context
	end

	def all_books
		qualifier = Qualifier.format "title like '*'"
		fetchspec = FetchSpec.new('Book', qualifier)
		@ec.fetch fetchspec
	end

	def all_publishers
		qualifier = Qualifier.format "name like '*'"
		fetchspec = FetchSpec.new('Publisher', qualifier)
		@ec.fetch fetchspec
	end

	def search( keywords_str, sort, like )
		case like
		when 2
			op = 'cilike'
		else
			op = 'like'
		end

		keywords = keywords_str.split /\s/
		format   = ''
		bindings = []
		keywords.each do |keyword|
			value = "*#{keyword}*"
			format << "(title #{op} %@) or "
			bindings << value
		end

		unless keywords.empty? then
			size = format.size - 5
			format = format[0..size]
		end
		qualifier = Qualifier.format(format, bindings)

		case sort
		when 2
			order = SortOrdering.new('title', SortOrdering::DESC)
		else
			order = SortOrdering.new('title', SortOrdering::ASC)
		end

		fetchspec = FetchSpec.new('Book', qualifier, [order])
		books = @ec.fetch fetchspec

		books
	end

	def register( title, publisher_name )
		qualifier = Qualifier.format("name == %@", [publisher_name])
		fetchspec = FetchSpec.new('Publisher', qualifier)
		publisher = @ec.fetch(fetchspec).first

		book = @ec.create 'Book'
		book['title'] = title
		book['publisher'] = publisher
		@ec.save
	end

	def register_with_new_publisher( title, publisher_name )
		publisher = @ec.create 'Publisher'
		publisher['name'] = publisher_name

		book = @ec.create 'Book'
		book['title'] = title
		book['publisher'] = publisher
		publisher['books'] << book
		@ec.save
	end

	def update( book, title, publisher_name )
		qualifier = Qualifier.format("title == %@", [book])
		fetchspec = FetchSpec.new('Book', qualifier)
		book      = @ec.fetch(fetchspec).first

		qualifier = Qualifier.format("name == %@", [publisher_name])
		fetchspec = FetchSpec.new('Publisher', qualifier)
		publisher = @ec.fetch(fetchspec).first

		book['title'] = title
		book['publisher'] = publisher
		@ec.save
	end

	def update_with_new_publisher( book, title, publisher_name )
		qualifier = Qualifier.format("title == %@", [book])
		fetchspec = FetchSpec.new('Book', qualifier)
		book      = @ec.fetch(fetchspec).first
		publisher = @ec.create 'Publisher'

		publisher['name'] = publisher_name
		book['title'] = title
		book['publisher'] = publisher
		publisher['books'] << book
		@ec.save
	end

	def delete( indexes )
		books = all_books

		indexes.each do |index|
			@ec.delete books[index]
		end

		@ec.save
	end
end
