module TapKit

	class NotificationCenter
		def initialize
			@observers = {} # observer -> [{symbol, name, object}, ...]
		end

		def add( observer, symbol, name, object = nil )
			regist          = {}
			regist[:symbol] = symbol
			regist[:name]   = name
			regist[:object] = object

			unless @observers[observer] then
				@observers[observer] = [regist]
			else
				unless @observers[observer].include? regist then
					@observers[observer] << regist
				end
			end
		end

		def add_omni( observer, symbol )
			add(observer, symbol, nil, nil)
		end

		def remove( observer, name = nil, object = nil )
			if name and object then
				regist = nil
				@observers[observer].each do |_regist|
					if (_regist[:name] == name) and (_regist[:object] == object) then
						regist = _regist
					end
				end

				if regist then
					@observer[observer].delete regist
				end
			else
				@observer.delete observer
			end
		end

		def remove_omni( observer )
			@observers.delete observer
		end

		def post( name, object, userinfo = nil )
			@observers.each do |observer, regists|
				regists.each do |regist|
					if ((regist[:name] == name) and (regist[:object] == object)) or \
						((regist[:name] == name) and (regist[:object] == nil)) or \
						(regist[:name] == nil) then
						nc = Notification.new(name, object, userinfo)
						observer.__send__(regist[:symbol], nc)
					end
				end
			end
		end
	end


	class Notification
		attr_reader :name, :object, :userinfo

		def initialize( name, object, userinfo = nil )
			@name     = name
			@object   = object
			@userinfo = userinfo
		end

		def ==( other )
			if (@name == other.name) and (@object == other.object) and \
				(@userinfo == other.userinfo) then
				true
			else
				false
			end
		end
	end

end

