module TapKit

	class DatabaseOperation
		attr_reader :gid, :object, :entity, :to_many_snapshots
		attr_accessor :database_operator, :db_snapshot, :new_row, :adapter_operations

		ADAPTER_LOCK_OPERATOR             = :adapter_lock_operator
		ADAPTER_DELETE_OPERATOR           = :adapter_delete_operator
		ADAPTER_INSERT_OPERATOR           = :adapter_insert_operator
		ADAPTER_UPDATE_OPERATOR           = :adapter_update_operator
		ADAPTER_STORED_PROCEDURE_OPERATOR = :adapter_stored_procedure_operator
		DATABASE_DELETE_OPERATOR          = :database_delete_operator
		DATABASE_INSERT_OPERATOR          = :database_insert_operator
		DATABASE_UPDATE_OPERATOR          = :database_update_operator
		DATABASE_NOTHING_OPERATOR         = :database_nothing_operator

		def initialize( gid, object, entity )
			@gid                = gid
			@object             = object
			@entity             = entity
			@db_snapshot        = @object.snapshot
			@adapter_operations = []
			@new_row            = {}
			@to_many_snapshots  = {}
		end

		def add_adapter_operation( adapter_operation )
			@adapter_operations << adapter_operation
		end

		def remove_adapter_operation( adapter_operation )
			@adapter_operations.delelte adapter_operation
		end

		def primary_key_diffs
			if @operator == DATABASE_UPDATE_OPERATOR then
				row_diffs @entity.primary_key_attributes
			else
				{}
			end
		end

		def row_diffs( attributes = nil )
			if attributes then
				keys = []
				attributes.each do |attr|
					keys << attr.name
				end
			else
				keys = @db_snapshot.keys
			end

			diffs = {}
			keys.each do |key|
				unless @db_snapshot[key] == new_row[key] then
					diffs[key] = new_row[key]
				end
			end
			diffs
		end

		def record_to_many_snapshot( gids, name )
			@to_many_snapshots[name] = gids
		end

		def record_to_many_snapshots( snapshots )
			snapshots.each do |name, gids|
				record_to_many_snapshot(gids, name)
			end
		end
	end

end
