#!/usr/local/bin/ruby

#
# register_csv - Registers data from CSV data
#

$LOAD_PATH.unshift '../lib'
require 'tapkit'
include TapKit

# title, artist, release
csv = <<EOF
Bach2000,Manhattan Jazz Orchestra,2000
Some Skunk Funk,Manhattan Jazz Orchestra,2002
Hey Duke!,Manhattan Jazz Orchestra,1999
A Night In Tunisia,Manhattan Jazz Orchestra,2002
Les Liaisons Dangereuses(No Problem),Manhattan Jazz Orchestra,1992
EOF


model = "model/single_entity.yaml"
app   = Application.new [model]
ec    = app.create_editing_context

csv.each do |line|
	fields = line.chomp.split ','

	# creates a new object
	# (and the 'create' method inserts automatically into the editing context)
	object = ec.create 'cd'
	object['title']   = fields[0]
	object['artist']  = fields[1]
	object['release'] = fields[2].to_i
end

puts "save changes the above"
ec.save

