package jp.sourceforge.talisman.xmlcli;

/*
 * $Id: ResourceOption.java,v 1.2 2006/02/26 09:47:59 harua-t Exp $
 */

import java.util.List;
import java.util.ResourceBundle;

import org.apache.commons.cli.Option;

/**
 * This class is used in {@link ResourceHelpFormatter
 * <code>ResourceHelpFormatter</code>} class.  User class do not need
 * to use this class.
 *
 * @author Haruaki TAMADA
 * @version $Revision: 1.2 $ $Date: 2006/02/26 09:47:59 $
 */
class ResourceOption extends Option{
    private ResourceBundle bundle;
    private Option option;

    public ResourceOption(ResourceBundle bundle, Option option){
        super(option.getOpt(), option.hasArgs(), option.getDescription());
        this.option = option;
        this.bundle = bundle;
    }

    public boolean equals(Object arg0) {
        return option.equals(arg0);
    }

    public String getArgName() {
        return option.getArgName();
    }

    public int getArgs() {
        return option.getArgs();
    }

    public String getDescription() {
        String description = option.getDescription().trim();
        if(description.startsWith("$(") && description.endsWith(")")){
            String key = description.substring(2, description.length() - 1);
            String value = bundle.getString(key);
            if(value != null){
                description = value;
            }
        }

        return description;
    }

    public int getId() {
        return option.getId();
    }

    public String getLongOpt() {
        return option.getLongOpt();
    }

    public String getOpt() {
        return option.getOpt();
    }

    public Object getType() {
        return option.getType();
    }

    public String getValue() {
        return option.getValue();
    }

    public String getValue(int index) throws IndexOutOfBoundsException {
        return option.getValue(index);
    }

    public String getValue(String defaultValue) {
        return option.getValue(defaultValue);
    }

    public String[] getValues() {
        return option.getValues();
    }

    public char getValueSeparator() {
        return option.getValueSeparator();
    }

    @SuppressWarnings("unchecked")
	public List<Object> getValuesList() {
        return (List<Object>)option.getValuesList();
    }

    public boolean hasArg() {
        return option.hasArg();
    }

    public boolean hasArgName() {
        return option.hasArgName();
    }

    public boolean hasArgs() {
        return option.hasArgs();
    }

    public int hashCode() {
        return option.hashCode();
    }

    public boolean hasLongOpt() {
        return option.hasLongOpt();
    }

    public boolean hasOptionalArg() {
        return option.hasOptionalArg();
    }

    public boolean isRequired() {
        return option.isRequired();
    }

    public void setArgName(String argName) {
        option.setArgName(argName);
    }

    public void setArgs(int num) {
        option.setArgs(num);
    }

    public void setLongOpt(String longOpt) {
        option.setLongOpt(longOpt);
    }

    public void setOptionalArg(boolean optionalArg) {
        option.setOptionalArg(optionalArg);
    }

    public void setRequired(boolean required) {
        option.setRequired(required);
    }

    public void setType(Object type) {
        option.setType(type);
    }

    public void setValueSeparator(char sep) {
        option.setValueSeparator(sep);
    }

    public String toString() {
        return option.toString();
    }

}
