/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.talisman.xmlcli.io;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import jp.sourceforge.talisman.xmlcli.io.Argf;
import jp.sourceforge.talisman.xmlcli.io.StreamChangeEvent;
import jp.sourceforge.talisman.xmlcli.io.StreamChangeListener;

public class ArgfInputStream
extends InputStream
implements Argf {
    private boolean stdin = false;
    private String[] fileNames;
    private InputStream current;
    private String currentFile;
    private List<StreamChangeListener> listeners = new ArrayList<StreamChangeListener>();
    private int index = 0;

    public ArgfInputStream(String[] fileNames) {
        this.fileNames = fileNames;
        if (fileNames == null) {
            this.current = System.in;
            this.stdin = true;
        }
    }

    public boolean isStdin() {
        return this.stdin;
    }

    public String getFileName() {
        return this.currentFile;
    }

    public int read() throws IOException {
        boolean flag;
        if (this.current == null && !(flag = this.next())) {
            return -1;
        }
        int c = this.current.read();
        boolean flag2 = false;
        if (c == -1) {
            flag2 = this.next();
        }
        if (flag2) {
            return this.read();
        }
        return c;
    }

    public int read(byte[] data, int off, int len) throws IOException {
        int size = 0;
        if (this.current == null) {
            return -1;
        }
        int i = 0;
        while (i < len) {
            int d = this.current.read();
            if (d == -1) {
                this.next();
                break;
            }
            data[i + off] = (byte)d;
            ++size;
            ++i;
        }
        return size;
    }

    public void addStreamChangeListener(StreamChangeListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void removeStreamChangeListener(StreamChangeListener listener) {
        this.listeners.remove(listener);
    }

    public int available() throws IOException {
        if (this.current == null) {
            return -1;
        }
        return this.current.available();
    }

    public long skip(long n) throws IOException {
        if (this.current == null) {
            throw new IOException("Already closed stream");
        }
        return this.current.skip(n);
    }

    public boolean markSupported() {
        if (this.current == null) {
            return false;
        }
        return this.current.markSupported();
    }

    public void mark(int limit) {
        if (this.current != null) {
            this.current.mark(limit);
        }
    }

    public void reset() throws IOException {
        if (this.current != null) {
            this.current.reset();
        }
    }

    public void close() throws IOException {
        this.fileNames = null;
        if (this.current != null) {
            this.current.close();
        }
        this.current = null;
    }

    private void fireEvent(StreamChangeEvent e) {
        for (StreamChangeListener listener : this.listeners) {
            switch (e.getID()) {
                case 1: {
                    listener.changeStream(e);
                    break;
                }
                case 2: {
                    listener.fileNotFound(e);
                }
            }
        }
    }

    private boolean next() throws IOException {
        if (this.current != null && !this.isStdin()) {
            this.current.close();
        }
        if (this.fileNames == null || this.index >= this.fileNames.length) {
            return false;
        }
        if (this.fileNames != null && this.index >= this.fileNames.length) {
            try {
                FileInputStream in = new FileInputStream(this.fileNames[this.index]);
                this.currentFile = this.fileNames[this.index];
                this.current = in;
                this.fireEvent(new StreamChangeEvent(this, 1));
            }
            catch (FileNotFoundException e) {
                this.fireEvent(new StreamChangeEvent(this, 2));
            }
        }
        return true;
    }
}

