package jp.sourceforge.talisman.csvio;

/*
 * $Id: CsvIOSetting.java 8 2007-08-11 03:41:33Z tama3 $
 */

import java.io.Serializable;

/**
 * I/O settings for csv file. 
 * 
 * @author Haruaki TAMADA
 * @version $Revision: 8 $ $Date: 2007-08-11 12:41:33 +0900 (Sat, 11 Aug 2007) $
 */
public class CsvIOSetting implements Serializable{
    private static final long serialVersionUID = -3459860376638200048L;

    private char separator;
    private char quoteBegin;
    private char quoteEnd;
    private char escapeCharacter = '\\';
    private QuotationMode quotationMode;
    private EscapeMode escapeMode;

    /**
     * Default constructor.
     * element separator is comma, quotation character is double quotation, and
     * element is quoted as needed, and escape mode is double character.
     */
    public CsvIOSetting(){
        this(',', '\"', '\"', QuotationMode.AS_NEEDED, EscapeMode.DOUBLE_CHARACTER);
    }

    /**
     * constructor with element separator.
     */
    public CsvIOSetting(char separator){
        this(separator, '\"', '\"', QuotationMode.AS_NEEDED, EscapeMode.DOUBLE_CHARACTER);
    }

    /**
     * constructor with given settings.
     */
    public CsvIOSetting(char separator, char quoteBegin, char quoteEnd,
                        QuotationMode quotationMode, EscapeMode escapeMode){
        setSeparator(separator);
        setQuoteBegin(quoteBegin);
        setQuoteEnd(quoteEnd);
        setQuotationMode(quotationMode);
        setEscapeMode(escapeMode);
    }

    /**
     * copy constructor
     */
    public CsvIOSetting(CsvIOSetting setting){
        setSeparator(setting.getSeparator());
        setQuoteBegin(setting.getQuoteBegin());
        setQuoteEnd(setting.getQuoteEnd());
        setQuotationMode(setting.getQuotationMode());
        setEscapeMode(setting.getEscapeMode());
        setEscapeCharacter(setting.getEscapeCharacter());
    }

    /**
     * returns quotation mode.
     */
    public QuotationMode getQuotationMode(){
        return quotationMode;
    }

    /**
     * sets quotation mode.
     */
    public void setQuotationMode(QuotationMode mode){
        this.quotationMode = mode;
    }

    /**
     * returns escape character.
     * This character is used in escape mode is
     * ESCAPE_CHARACTER.
     */
    public char getEscapeCharacter(){
        return escapeCharacter;
    }

    /**
     * sets escape character.
     */
    public void setEscapeCharacter(char escapeCharacter){
        this.escapeCharacter = escapeCharacter;
    }

    /**
     * returns escape mode.
     */
    public EscapeMode getEscapeMode(){
        return escapeMode;
    }

    /**
     * sets escape mode.
     */
    public void setEscapeMode(EscapeMode escapeMode){
        this.escapeMode = escapeMode;
    }

    /**
     * returns left side quotation character.
     */
    public char getQuoteBegin(){
        return quoteBegin;
    }

    /**
     * sets left side quotation character.
     */
    public void setQuoteBegin(char quoteBegin){
        this.quoteBegin = quoteBegin;
    }

    /**
     * returns right side quotation character.
     */
    public char getQuoteEnd(){
        return quoteEnd;
    }

    /**
     * sets right side quotation character.
     */
    public void setQuoteEnd(char quoteEnd){
        this.quoteEnd = quoteEnd;
    }

    /**
     * returns element separator character.
     */
    public char getSeparator(){
        return separator;
    }

    /**
     * sets element separator character.
     */
    public void setSeparator(char separator){
        this.separator = separator;
    }
}
