CREATE TABLE "tstamp" (
	"key" text,
	"time" timestamp with time zone
);
REVOKE ALL on "tstamp" from PUBLIC;
GRANT ALL on "tstamp" to "%dbname%";
GRANT ALL on "tstamp" to "nobody";


CREATE TABLE "basenote" (
	"id" serial,
	"uid" integer,
	"entry" timestamp with time zone,
	"latest" timestamp with time zone,
	"title" text,
	"article" text,
	"resnum" integer,
	"reschain" text,
	"status" text
);
REVOKE ALL on "basenote" from PUBLIC;
GRANT ALL on "basenote" to nobody;
GRANT ALL on "basenote" to "%dbname%";
REVOKE ALL on "basenote_id_seq" from PUBLIC;
GRANT ALL on "basenote_id_seq" to nobody;
GRANT ALL on "basenote_id_seq" to "%dbname%";


CREATE TABLE "response" (
	"id" serial,
	"uid" integer,
	"bid" integer,
	"latest" timestamp with time zone,
	"article" text,
	"status" text
);
REVOKE ALL on "response" from PUBLIC;
GRANT ALL on "response" to PUBLIC;
GRANT ALL on "response" to "%dbname%";
REVOKE ALL on "response_id_seq" from PUBLIC;
GRANT ALL on "response_id_seq" to PUBLIC;
GRANT ALL on "response_id_seq" to "%dbname%";


CREATE TABLE "evaluation" (
	"id" serial,
	"iid" integer,
	"uid" integer,
	"comment" text,
	"rate" double precision,
	"point" double precision,
	"cid" integer,
	"type" text,
	"entry" timestamp with time zone,
	"latest" timestamp with time zone
);
REVOKE ALL on "evaluation" from PUBLIC;
GRANT ALL on "evaluation" to "%dbname%";
GRANT ALL on "evaluation" to "nobody";
REVOKE ALL on "evaluation_id_seq" from PUBLIC;
GRANT ALL on "evaluation_id_seq" to "%dbname%";
GRANT ALL on "evaluation_id_seq" to "nobody";


CREATE TABLE "similarity" (
	"sim" double precision,
	"uid1" integer,
	"uid2" integer,
	"latest" timestamp with time zone
);
REVOKE ALL on "similarity" from PUBLIC;
GRANT ALL on "similarity" to "%dbname%";
GRANT ALL on "similarity" to "nobody";

CREATE TABLE "affinity" (
	"aff" double precision,
	"uid" integer,
	"iid" integer,
	"latest" timestamp with time zone
);
REVOKE ALL on "affinity" from PUBLIC;
GRANT ALL on "affinity" to "%dbname%";
GRANT ALL on "affinity" to "nobody";

CREATE TABLE "isimilarity" (
	"sim" double precision,
	"iid1" integer,
	"iid2" integer,
	"latest" timestamp with time zone
);
REVOKE ALL on "isimilarity" from PUBLIC;
GRANT ALL on "isimilarity" to "%dbname%";
GRANT ALL on "isimilarity" to "nobody";

CREATE TABLE "msgbox" (
	"id" serial,
	"fid" integer,
	"tid" integer,
	"ref" integer,
	"title" text,
	"article" text,
	"read" timestamp with time zone,
	"reply" timestamp with time zone,
	"entry" timestamp with time zone
);
REVOKE ALL on "msgbox" from PUBLIC;
GRANT ALL on "msgbox" to "%dbname%";
GRANT ALL on "msgbox" to "nobody";
REVOKE ALL on "msgbox_id_seq" from PUBLIC;
GRANT ALL on "msgbox_id_seq" to "%dbname%";
GRANT ALL on "msgbox_id_seq" to "nobody";

CREATE TABLE "wishlist" (
	"id" serial,
	"iid" integer,
	"uid" integer,
	"seq" integer,
	"memo" text,
	"entry" timestamp with time zone,
	"latest" timestamp with time zone
);
REVOKE ALL on "wishlist" from PUBLIC;
GRANT ALL on "wishlist" to "%dbname%";
GRANT ALL on "wishlist" to "nobody";
REVOKE ALL on "wishlist_id_seq" from PUBLIC;
GRANT ALL on "wishlist_id_seq" to "%dbname%";
GRANT ALL on "wishlist_id_seq" to "nobody";

CREATE TABLE "special" (
	"id" serial,
	"title" text,
	"subtitle" text,
	"article" text,
	"uid" integer,
	"entry" timestamp with time zone,
	"latest" timestamp with time zone,
	"publish" integer
);
REVOKE ALL on "special" from PUBLIC;
GRANT ALL on "special" to "%dbname%";
GRANT ALL on "special" to "nobody";
REVOKE ALL on "special_id_seq" from PUBLIC;
GRANT ALL on "special_id_seq" to "%dbname%";
GRANT ALL on "special_id_seq" to "nobody";

CREATE TABLE "spmember" (
	"iid" integer,
	"sid" integer,
	"rank" integer
);
REVOKE ALL on "spmember" from PUBLIC;
GRANT ALL on "spmember" to "%dbname%";
GRANT ALL on "spmember" to "nobody";

CREATE TABLE "userauth" (
	"id" integer,
	"realname" text,
	"read" text,
	"email" text,
	"nickname" text,
	"handle" text,
	"password" text,
	"zipcode" text,
	"gender" integer,
	"age" integer,
	"acceptmail" integer,
	"entry" timestamp with time zone,
	"latest" timestamp with time zone,
	"level" integer,
	"class" integer,
	"sessid" text
);
REVOKE ALL on "userauth" from PUBLIC;
GRANT ALL on "userauth" to "%dbname%";
GRANT ALL on "userauth" to "nobody";

CREATE TABLE "userdata" (
	"id" integer,
	"uid" integer,
	"hptitle" text,
	"url" text,
	"linkref" text,
	"goto" integer,
	"comefrom" integer,
	"acount" integer,
	"rcount" integer,
	"ccount" integer,
	"category" text,
	"area" text,
	"comment" text
);
REVOKE ALL on "userdata" from PUBLIC;
GRANT ALL on "userdata" to "%dbname%";
GRANT ALL on "userdata" to "nobody";

CREATE UNIQUE INDEX response_id_key ON response USING btree (id);

CREATE UNIQUE INDEX evaluation_id_key ON evaluation USING btree (id);

CREATE UNIQUE INDEX msgbox_id_key ON msgbox USING btree (id);

CREATE UNIQUE INDEX wishlist_id_key ON wishlist USING btree (id);

CREATE UNIQUE INDEX basenote_id_key ON basenote USING btree (id);

CREATE INDEX tstamp_key ON tstamp USING btree ("key");

CREATE INDEX dirty_key ON dirty USING btree ("key");

CREATE INDEX similarity_key ON similarity USING btree (uid1, uid2);

CREATE INDEX isimilarity_key ON isimilarity USING btree (iid1, iid2);

CREATE INDEX special_id_key ON special USING btree (id);

CREATE INDEX spmember_id_key ON spmember USING btree (sid, iid);

CREATE INDEX userauth_id_key ON userauth USING btree (id);

CREATE INDEX userdata_id_key ON userdata USING btree (id);

