CREATE TABLE %item% (
	"id" serial,
	"name" text,
	"alphabet" text,
	"read" text,
	"property" text,
	"chain" text,
	"area" text,
	"zipcode" text,
	"address1" text,
	"address2" text,
	"tel" text,
	"fax" text,
	"url" text,
	"email" text,
	"card" text,
	"closeday" text,
	"openwday" text,
	"ivfromwday" text,
	"ivtowday" text,
	"closewday" text,
	"stalunchwday" text,
	"endlunchwday" text,
	"opensday" text,
	"ivfromsday" text,
	"ivtosday" text,
	"closesday" text,
	"stalunchsday" text,
	"endlunchsday" text,
	"openhday" text,
	"ivfromhday" text,
	"ivtohday" text,
	"closehday" text,
	"stalunchhday" text,
	"endlunchhday" text,
	"description" text,
	"auther" text,
	"entry" timestamp,
	"latest" timestamp,
	"caid1" integer,
	"caid2" integer,
	"caid3" integer,
	"caid4" integer,
	"caid5" integer,
	"arid" integer,
	"closed" integer,
	"cnum" integer,
	"rateavg" float,
	"ratesum" integer,
	"uid" integer
);
REVOKE ALL on "%item%" from PUBLIC;
GRANT ALL on "%item%" to "gourmet";
GRANT ALL on "%item%" to "nobody";
REVOKE ALL on "%item%_id_seq" from PUBLIC;
GRANT ALL on "%item%_id_seq" to "gourmet";
GRANT ALL on "%item%_id_seq" to "nobody";

CREATE INDEX %item%_index ON %item% USING btree (name, "read", alphabet, arid, tel, caid1, caid2, caid3, caid4, caid5);

CREATE UNIQUE INDEX %item%_id_key ON %item% USING btree (id);

