<?php
/************************************************************************
	UebiMiau is a GPL'ed software developed by

	 - Aldoir Ventura - aldoir@users.sourceforge.net
	 - http://uebimiau.sourceforge.net

	Fell free to contact, send donations or anything to me :-)
	S Paulo - Brasil

	**********************************************
	Version 3.2.0 Upgrades and templates developed by

	 - Todd Henderson - Lead Developer
	 - http://tdah.us
	 - Email: todd@tdah.us

	 - Dave Rodgers - Project Consultant
	 - http://www.manvel.net
	 - Email: Davenmanvel@inbox.com

	Feel free to contact us, send donations or anything to me as well...

	Special thanks to the developers at telaen.org, codeworxtech.com, tinymce.moxiecode.com
	without help this project wouldn't be possible

	**********************************************
	- File:			startchat.php
	- Developer: 	Todd Henderson / Mods by Laurent (AdNovea)
	- Date:			November 4, 2008
	- version:		(3.2.0) 1.0
	- Description:  Load chat room

*************************************************************************/
 	header("cache-Control: no-cache, must-revalidate"); 
	header("Expires: Mon, 26 Jul 1997 05:00:00 GMT"); 				
	
	require("./inc/functions.php");
	require(PATH_LANGS."$chat_language.php");
	$chat_data_file 	= DB_CHAT_DATA;
  $chat_online_file 	= DB_CHAT_ONLINE;
  $chat_upload_dir 	= DB_CHAT_UPLOAD;
 
	
// Already logged (will display chat room)
	if ( isset($_SESSION['nickname']) ) {

	// Set nickname and language
		$name = isset($_POST['name']) ? $_POST['name'] : CHAT_UNNAMED;
		$nick = $_SESSION['nickname'];
		$lid = isset($_GET['lid']) ? $_GET['lid'] : $lid;

	// Prepare message page
		header("Cache-control: private");
		echo "<link rel='stylesheet' type='text/css' href='./themes/$selected_theme/$chat_default_theme'>";
		
	// if Status changed, update user list accordingly
		if (isset($_GET['status']) && ($_SESSION['chatstatus'] != $_GET['status'])) {
			if (!$f_text = file($temporary_directory.DB_CHAT_ONLINE)) echo CHAT_CANNOT_OPENFILE;
			$file_handle = fopen($temporary_directory.DB_CHAT_ONLINE,"w");
			foreach($f_text as $line) {				// Rewrite the file but remove the current user from list
				 if ( !strstr($line,$nick) )
					   fputs($file_handle,$line);
			}
			switch ($status) {
				case 2: $status_msg = CHAT_BUSY; $pic = "pic_busy"; $classname="logout"; break;
				case 3: $status_msg = CHAT_BRB; $pic = "pic_brb"; $classname="logout"; break;
				case 4: $status_msg = CHAT_AWAY; $pic = "pic_away"; $classname="logout"; break;
				default: $status_msg = CHAT_ONLINE; $pic = "pic_online"; $classname="login"; break;
			}
			fclose($file_handle);
			
			// Update user list
			$data = "<a href=\"newmsg.php?nameto=$nick&mailto=$f_user\" title=\"$status_msg ($f_user) - ".CHAT_CLICK2PM."\" target=\"blank\">$nick</a>";
			if (!$file_handle = fopen($temporary_directory.DB_CHAT_ONLINE,"a+")) echo CHAT_CANNOT_OPENFILE;
			if (!fwrite($file_handle, "<div class=\"user_online $pic\"> $data</div>\n")) echo CHAT_CANNOT_WRITEFILE;
			fclose($file_handle);
			
			// Add message to the chat-room
			if ($chat_timestamp  == "yes") {
				$date = date($chat_time_format);
				$data = "<p><span class=\"date\">[$date]</span> "; 
			} else 
				$data = "<p>";
			$data .= "<span class=\"main\">$nick</span> <span class=\"$classname\"> ".CHAT_ISNOW." $status_msg</span></p>";
			if (!$file_handle = fopen($temporary_directory.DB_CHAT_DATA,"a+")) echo CHAT_CANNOT_OPENFILE;
			if (!fwrite($file_handle, $data)) echo CHAT_CANNOT_WRITEFILE;
			fclose($file_handle);
			$_SESSION['chatstatus'] = $status;
			unset($_GET['status']);
		}
		$smarty->assign("umStatus",$status);


	// Load Messages
		$chat_result = "";
		if (!$data = file($temporary_directory.DB_CHAT_DATA)) echo CHAT_CANNOT_OPENFILE;
		foreach ($data as $line) $chat_result .= $line;


	// Load Users list
		if (!file_exists($temporary_directory.DB_CHAT_ONLINE)) {
			if (!$file_handle = fopen($temporary_directory.DB_CHAT_ONLINE,"a")) echo CHAT_CANNOT_OPENFILE;
		}
		$lines = count(file($temporary_directory.DB_CHAT_ONLINE));
		$smarty->assign("umChatLines",$lines);

		$chat_result = "";
		$data = file($temporary_directory.DB_CHAT_ONLINE);
		foreach ($data as $line) {
			$chat_result .= $line;
		}
		$smarty->assign("umChatUsers",$chat_result);


	// Load Uploaded file list
		$folder = dir($temporary_directory.DB_CHAT_UPLOAD);
		$lines = 0;
		$chat_result = "";
		
		//$chat_upload_dir 	= DB_CHAT_UPLOAD;
		while ($entry = $folder->read()) if ($entry != "." && $entry != "..") {
			$data  = "<div class=\"user_online pic_upload\"> ";
			$data .= "<a href=\"$temporary_directory/$chat_upload_dir/$entry\" title=\"$entry\" target=\"main\">$entry</a>";
			$data .= "</div><br>\n";
			$lines++;
			$chat_result .= $data;
		}
		$smarty->assign("umFilesNum",$lines);
		$smarty->assign("umChatfiles",$chat_result);
		$logged = 1;

	} else {

// Not yet logged (will display welcome page for chat connection)
		$prefs = load_prefs();
		$nick = $prefs["nick-name"];
		$nick = ($nick) ? $nick : $prefs["real-name"];
		$nick = ($nick) ? $nick : substr($f_user,0,strrpos($f_user, "@"));
		$logged = 0;
	}

// Set SMARTY variables for templates and display
	$smarty->assign("umNickName", $nick);
	$smarty->assign("umChatFileSize",CHAT_TEXT_SIZE);
	$smarty->assign("umChatFileMaxSize",$chat_max_file_size);
	$smarty->assign("umChat",$logged);
	$smarty->assign("umTidID",$tid);	// This is the real Theme name not the path (needed for the IFRAME)
	$smarty->assign("umSmileys",$chat_smileys);
	$chat_smileys_vars = "var smiley_code = new Array();\n";
	for ($i=0; $i< count($smiley_code); $i++) $chat_smileys_vars .= "smiley_code[$i] = '".$smiley_code[$i]."'\n";
	$smarty->assign("umSmileyVars",$chat_smileys_vars);
	$smarty->assign("umCharSet",$default_char_set);
	
	$smarty->display("$selected_theme/".HTML_CHAT_BOX);

?>


