package net.smokerz.linux.misc.batterymonitor;

import java.util.ArrayList;
import java.io.FileReader;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.StringTokenizer;
import net.smokerz.linux.misc.batterymonitor.model.*;
/**
 * get Proc Info
 *
 * @author smoker
 * @version 0.0.1(2002/06/02)
 */
public class GetACPIProcInfo {
	/**
	 * DEBUG FLAG
	 */
	private boolean DEBUG = false;

	/**
	 * ACPI Battery Base PATH
	 */
	private String path = null;

	/**
	 * ACPIPRocInfoModel
	 */
	private ACPIProcInfoModel info = null;
	
	/**
	 *
	 * @param path ACPI Battery Base PATH
	 */
	public GetACPIProcInfo(String path) {
		this.path = path;
		String envDebug = System.getProperty("DEBUG");
		if (envDebug != null && envDebug.equals("true")) {
			this.DEBUG = true;
		}
		
	}

	/**
	 *
	 * @throws ACPIBatteryNotFoundException ACPIBatteryNotFoundException
	 * @throws FileNotFoundException FileNotFoundException
	 * @throws IOException IOException
	 */
	public void init() throws ACPIBatteryNotFoundException, FileNotFoundException, IOException{
		if (DEBUG) {
			System.out.println("start init info");
			System.out.println("TARGET [" + this.path + ACPISymbols.INFO + "]");
		}
		BufferedReader in = new BufferedReader(new FileReader(this.path + ACPISymbols.INFO));
		ArrayList list = new ArrayList();
		for(int i = 0; i <= 12; i++) {
			String str = in.readLine();
			//if (DEBUG) System.out.println(str);
			if (str == null || str.length() <= 0) {
				throw new ACPIBatteryNotFoundException();
			}
			StringTokenizer token = new StringTokenizer(str, ":");
			String key = token.nextToken();
			String value = token.nextToken();
			if ( i == 0 && value != null && value.equals(ACPISymbols.NO)) {
				throw new ACPIBatteryNotFoundException("no present...");
			}

			if (DEBUG) System.out.println(key + " : " + value);
			list.add(value.trim());
		}
		if (in != null) {
			in.close();
			in = null;
		}

		this.info= new ACPIProcInfoModel(
					(String)list.get(0),
					getIntValue((String)list.get(1)),
					getIntValue((String)list.get(2)),
					(String)list.get(3),
					getIntValue((String)list.get(4)),
					getIntValue((String)list.get(5)),
					getIntValue((String)list.get(6)),
					getIntValue((String)list.get(7)),
					getIntValue((String)list.get(8)),
					(String)list.get(9),
					(String)list.get(10),
					(String)list.get(11),
					(String)list.get(12)
					);

		if (DEBUG) {
			System.out.println("PRESENT [" + this.info.getPresent() + "]");
			System.out.println("DESIGN CAPACITY [" + this.info.getDesignCapacity() + "]");
			System.out.println("end init info...");
		}
	}

	/**
	 * get ACPIProcInfoModel
	 * @return ACPIProcInfoModel mdoel
	 */
	public ACPIProcInfoModel getInfoModel() {
		return this.info;
	}

	/**
	 * get Integer value
	 * @param str
	 * @return int integer value
	 */
	private int getIntValue(String str) {
		StringTokenizer token = new StringTokenizer(str);
		return Integer.parseInt(token.nextToken().trim());
	}
}

