package net.smokerz.linux.misc.batterymonitor;

import java.io.FileNotFoundException;
import java.io.IOException;
import net.smokerz.linux.misc.batterymonitor.ACPISymbols;
import net.smokerz.linux.misc.batterymonitor.model.ACPIProcModel;
import net.smokerz.linux.misc.batterymonitor.model.ACPIProcStateModel;
import net.smokerz.linux.misc.batterymonitor.model.ACPIProcInfoModel;
/**
 * ACPI UTILITY
 * @author smoker
 * @version 0.0.1(2002/06/13)
 * @see ACPISymbols
 * @see ACPIProcModel
 * @see ACPIProcStateModel
 * @see ACPIProcInfoModel
 */
public class ACPIUtil {
	/**
	 * ACPIT Battery Base uri
	 */
	private String PATH = null;
	/**
	 * DEBUG FLAG
	 */
	private boolean DEBUG = false;
	/**
	 * ACPIProcModel
	 */
	private ACPIProcModel acpiProcModel = null;
	
	/**
	 * 
	 * @param path ACPI Battery uri
	 */
	public ACPIUtil(String path) {
		String DEBUG = System.getProperty("DEBUG");
		if(DEBUG != null && DEBUG.equals("true")) { this.DEBUG = true; }
		this.PATH = path;
	}

	public void init() {
		GetACPIProc getProc = new GetACPIProc(this.PATH);
		try {
			getProc.init();
		} catch (Exception e) {
			e.printStackTrace();
		}
		this.acpiProcModel = getProc.getACPIModel();
	}

	/**
	 * get ACPI Charging parsentage
	 */
	public double getParsentage() {
		if (DEBUG) System.out.println("start ACPIUtil.getParsentage .....");
		double parsent = 0;
		ACPIProcStateModel stateModel = this.acpiProcModel.getState();
		ACPIProcInfoModel infoModel = acpiProcModel.getInfo();
		double full = infoModel.getLastFullCapacity();
		double now = stateModel.getRemainingCapacity();
		if (DEBUG) {
			System.out.println("FULL [" + full + "]");
			System.out.println("NOW [" + now + "]");
		}

		if (DEBUG) System.out.println("PARSENT [" + now / full + "]");
		parsent = now / full;

		if (DEBUG) System.out.println("end ACPIUtil.getParsentage .....");
		return parsent;
	}

	/**
	 * hasBattery
	 */
	public boolean hasBattery() {
		if (DEBUG) System.out.println("start ACPIUtil.hasBattery  .......");
		boolean infoPresent = false;
		boolean statePresent = false;
		boolean retFlg = false;

		if (this.acpiProcModel.getInfo() != null && 
			this.acpiProcModel.getInfo().getPresent().equals(ACPISymbols.YES)) {
			infoPresent = true;
		}
		
		if (this.acpiProcModel.getState() != null &&
			this.acpiProcModel.getState().getPresent().equals(ACPISymbols.YES)) {
			statePresent = true;
		}

		if (infoPresent && statePresent) {
			retFlg = true;
		}

		if (DEBUG) System.out.println("end ACPIUtil.hasBattery .......");
		return retFlg;
	}

	/**
	 * hasCharging
	 */
	public boolean hasCharging() {
		if (DEBUG) System.out.println("start ACPIUtil.hasCharging .....");
		boolean retFlag = false;

		if (this.acpiProcModel.getState().getChargingState().equals(ACPISymbols.CHARGING)) {
			retFlag = true;
		}
		if (DEBUG) System.out.println("HASCHARGING [" + retFlag + "]");
		
		if (DEBUG) System.out.println("end ACPIUtil.hasCharging ....");
		return retFlag;
	}

	/**
	 * get ACPIProcModel
	 * @return ACPIProcModel acpiProcModel
	 */
	public ACPIProcModel getModel() {
		return this.acpiProcModel;
	}

	/**
	 * get ACPI Battery Base PATH
	 * @return String ACPI Battery Base PATH
	 */
	public String getPath() {
		return this.PATH;
	}
	
	/**
	 * set ACPI Battery Base PATH
	 * @param path ACPI Battery Base PATH
	 */
	public void setPath(String path) {
		this.PATH = path;
	}
}

