#-*- mode:perl; coding:euc-jp -*-
#$Id: log.pm,v 1.2 2007/07/04 09:22:08 kohju Exp $
#
#------------------------------------
# logѥå 
#------------------------------------
package log;
use strict;


# our @EXPORT    = qw(add Error);
use CGI qw/:standard/;
use def;
use servermode;
use config;


#------------------------------------
# in  : level userno productno command message
# out : 
#log::add(level command message);
#date time level command message 
#2002/12/14 16:12:34 error send_mail 顼
#                    warn
#                    event
#------------------------------------
my @errorlevel = qw(event warn error);

#顼ɵ
#in :Ϣ(filename, level, command, message)
sub add
{
    my ($level, $command, $message) = @_;
    my ($sec, $min, $hour, $mday, $mon, $year, $wday, $yday, $isdst)  = localtime(time);
    #year/month/day hour:min:sec
    my $log = sprintf("%04d/%02d/%02d %02d:%02d:%02d %-5s %-16s %s [ver %s]\n", 
		      $year+1900, $mon+1, $mday,
		      $hour, $min, $sec,
		      $errorlevel[$level],
		      $command,
		      $message,
		      $VERSION);

    my $openfile = &servermode::getRealLogPath($servermode::LOGFILE);
    unless (open(OUT, ">>$openfile"))
    {
	Error("ե뤬񤭹ߥץǤޤ[$openfile]", "");
	return;
    }

    flock(OUT, 2);
    seek(OUT, 0, 2);
    print OUT $log;
    close(OUT);
    if ($level != 0){
	open(OUT, ">>".&servermode::getRealLogPath($servermode::ERRORLOGFILE));
	flock(OUT, 2);
	seek(OUT, 0, 2);
	print OUT $log;
	close(OUT);
    }

}

#------------------------------------
# MSGɽ
# in  : MSG
# out : 
#------------------------------------
sub DispMSG
{
    my ($MSG,@lines)=@_;
    my $q = new CGI;
    my $line="";
    print 
	header(-type=>'text/html',
		   -charset=>'EUC-JP'),
	start_html(-title=>"$MSG",
		       -lang=>"euc=jp"),
        hr,
	h1("$MSG"),
        hr;

    foreach $line (@lines){
	print p("$line");
    }
    print 
	hr,
	p({-align=>'right'},"Symreq Version $VERSION, Copyright (C) 2006-2007 Symreq Development Team, Lisense is BSD. based on Symreq 2.0 by JUSTPLAYER Co.,Ltd."),
	end_html;
}

#------------------------------------
# ErrorMSGɽƽλ롣
# in  : MSG
# out : 
#------------------------------------
sub Error
{
    my ($ErrorMSG,@lines)=@_;
    &DispErrorMSG($ErrorMSG, "error", @lines);
    exit();
}

#------------------------------------
# WarningMSGɽ³Ԥ롣
# in  : MSG
# out : 
#------------------------------------
sub Warning
{
    my ($WarnMSG,@lines)=@_;
    &DispErrorMSG($WarnMSG, "warning", @lines);
}

#------------------------------------
# ॹդ顼ɽ
# in  : åס顼
# out : 
#------------------------------------
sub DispErrorMSG
{
    my ($MSG, $type, @lines)=@_;
    &DispMSG($MSG,@lines);
    &printFormatLine($type, $MSG);
}

sub getThisTimeFormated
{
# Fri Nov 12 20:09:05 2004
    my ($sec,$min,$hour,$mday,$mon,$year,$wday,$yday,$isdat)=localtime(time);
    my @day_list=qw(Sun Mon Tue Wed Thu Fri Sat);
    my $day=$day_list[$wday];
    my @month_list=qw(Jan Feb Mer Apr May Jun Jul Aug Sep Oct Nov Dec);
    my $month=$month_list[$mon];

    return "$day $month $mday $hour:$min:$sec ".(1900+$year);
}

sub printFormatLine
{
    my ($ErrorType,$ErrorMSG)=@_;

    print STDERR "[".&getThisTimeFormated()." ] [$ErrorType] $ErrorMSG\n";
}

1;
