#-*- mode:perl; coding:euc-jp -*-
#$Id: math.pm,v 1.1.1.1 2007/04/18 16:16:05 kohju Exp $
#
#------------------------------------
# إѥå 
#------------------------------------
package math;
@EXPORT=qw(isnum Numeric Trunc Round Roundup Sum Sub Mul Div gt gte lt lte ne eq Cmp If);
use Jcode;
use def;
use config;
use servermode;
use log;

#------------------------------------
# ͥå
# in  : Ƚꤹ
# out : TRUE:͡FALSE:ͤǤϤʤ
#------------------------------------
sub isnum
{
    my ($src)=@_;
    return 0 unless(defined($src));
    if($src=~/(^[-0-9]+$)|([0-9]*\.[0-9]+$)|(([0-9]*\.[0-9]+)([eE][+]?[0-9]+))/){
	return $TRUE;
    }else{
	return $FALSE;
    }
}

#------------------------------------
# Ͳ 
# in  : 10ʿʸ 
# out : 10ʿ 
#------------------------------------
sub Numeric
{
    my ($src) = @_;
    return 0 unless(defined($src));
    $src=Jcode->new($src)->tr('-','0-9');
    $src=0    unless($src);
    return $src;
}

#------------------------------------
# ڤΤ 
# in  : 10ʿ
# out : 10ʿ
#------------------------------------
sub Trunc			
{
    my ($src) = @_;
    return 0 unless(defined($src));
    my $ret = &Numeric($src);
    return int($ret) if($ret);
    return "";
}

#------------------------------------
# ͼθ 
# in  : 10ʿ
# out : 10ʿ
#------------------------------------
sub Round
{
    my ($src) = @_;
    return 0 unless(defined($src));
    my $ret = &Numeric($src);
    return int($ret + 0.5) if($ret);
    return "";
	
}

#------------------------------------
# ڤ夲
# in  : 10ʿ
# out : 10ʿ
#------------------------------------
sub Roundup
{
    my ($src)=@_;
    return 0 unless(defined($src));
    my $ret=&Numeric($src);
    return "" unless($ret);
    return (int($ret) == $ret) ? $ret : int($ret + 1); 
}


#------------------------------------
# Oplandι֤ͤ ʿ͡
# in  : ­1,­2,­3...­n
# out :  
# +=
# ʸ+=ʸ
# ʸ+ʸ=ʸ
# +ʸ=ʸ
# ex)sum(1,2,"ab",4) = 3ab4
#------------------------------------
sub Sum	
{
    my (@opland) = @_;
    my $sum;
    if(&isnum($opland[0])){
	$sum=0;
    }else{
	$sum="";
    }
    foreach my $src (@opland){
	my $ret=&Numeric($src);
	if(&isnum($sum) && &isnum($ret)){
	    $sum+=$ret;
	}else{
	    $sum.=$src;
	}
    }
    return $sum;
}


#------------------------------------
# Opland(&&)
# in  : 12ġn
# out : Ѥη
# ex)land(1,2,"a",4) = TRUE
#------------------------------------
sub land
{
    my (@opland) = @_;
    $ret=1;
    foreach my $src (@opland){
	$ret=($ret && $src);
    }
    if($ret){
	return $TRUE;
    }else{
	return $FALSE;
    }
}

#------------------------------------
# Opland(||)
# in  : 12ġn
# out : ¤η
# ex)lor(1,0,0,0) = TRUE
#------------------------------------
sub lor
{
    my (@opland) = @_;
    $ret=0;
    foreach my $src (@opland){
	$ret=($ret || $src);
	return $TRUE if($ret);
    }
    return $FALSE;
}

#------------------------------------
# Oplandnot(!)
# in  : 
# out : not
# ex)not(1) = 0
#------------------------------------
sub not
{
    return $TRUE unless ($_[0]);
    return $FALSE;
}

#------------------------------------
# 
# in  : s1, s2
# out : s1 - s2
#------------------------------------
sub Sub
{
    my (@opland)=@_;
    if (!defined($opland[0]) || !defined($opland[1])){
	&log::add(1, "math::Sub", "Ƥޤ");
	return "Sub():Ƥޤ";
    }
    my ($s1,$s2)=($opland[0],$opland[1]);

    $s1=&Numeric($s1);
    $s2=&Numeric($s2);
    if(&isnum($s1) && &isnum($s2)){
	return $s1 - $s2;
    }else{
	&log::add(1, "math::Sub", "ͤǤϤʤޤ");
	return "Sub():ͤǤϤʤޤ";
    }
}

#------------------------------------
# ݤ
# in  : src, dst
# out : src * dst
#------------------------------------
sub Mul				# src*dst
{
    my (@opland)=@_;
    if (!defined($opland[0]) || !defined($opland[1])){
	&log::add(1, "math::Mul", "Ƥޤ");
	return "Mul():Ƥޤ";
	return 0;
    }
    my ($s1,$s2)=($opland[0],$opland[1]);
    $s1=&Numeric($s1);
    $s2=&Numeric($s2);
    if(&isnum($s1) && &isnum($s2)){
	return $s1 * $s2;
    }else{
	return 0;
#	&log::add(1, "math::Mul", "ͤǤϤʤޤ($s1)($s2)");
#	return "Mul():ͤǤϤʤޤ";
    }
    
}

#------------------------------------
# 껻
# in  : s1, s2
# out : s1 / s2
#------------------------------------
sub Div				# src/dst
{
    my (@opland)=@_;
    if (!defined($opland[0]) || !defined($opland[1])){
	&log::add(1, "math::Div", "Ƥޤ");
	return "#Div():Ƥޤ";
    }
    my ($s1,$s2)=($opland[0],$opland[1]);
    unless ($s2){
	&log::add(2, "math::Div", "顼");
	return "#Divzero";
    }

    $s1=&Numeric($s1);
    $s2=&Numeric($s2);
    if(&isnum($s1) && &isnum($s2)){
	return $s1 / $s2;
    }else{
	&log::add(1, "math::Div", "ͤǤϤʤޤ");
	return "#Div():ͤǤϤʤޤ";
    }

}

#------------------------------------
# grater than
# in  : src1, src2
# out : true,false
#   sr1>src2ΤȤtrue֤뤬ʳʥ顼ޤˤfalse֤
#------------------------------------
sub gt
{
    my (@opland)=@_;
    if (!defined($opland[0]) || !defined($opland[1])){
	&log::add(1, "math::gt", "Ƥޤ");
	return "gt():Ƥޤ";
    }
    my ($s1,$s2)=($opland[0],$opland[1]);

    $s1=&Numeric($s1);
    $s2=&Numeric($s2);
    if(&isnum($s1) && &isnum($s2)){
	if($s1 > $s2){
	    return $TRUE;
	}else{
	    return $FALSE;
	}
    }else{
	&log::add(1, "math::gt", "ͤǤϤʤޤ");
	return "gt():ͤǤϤʤޤ";
    }
}

#------------------------------------
# grater equal than
# in  : src1, src2
# out : true,false
#   sr1>=src2ΤȤtrue֤뤬ʳʥ顼ޤˤfalse֤
#------------------------------------
sub gte
{
    my (@opland)=@_;
    if (!defined($opland[0]) || !defined($opland[1])){
	&log::add(1, "math::gte", "Ƥޤ");
	return "gte():Ƥޤ";
    }
    my ($s1,$s2)=($opland[0],$opland[1]);

    $s1=&Numeric($s1);
    $s2=&Numeric($s2);
    if(&isnum($s1) && &isnum($s2)){
	if($s1 >= $s2){
	    return $TRUE;
	}else{
	    return $FALSE;
	}
    }else{
	&log::add(1, "math::gte", "ͤǤϤʤޤ($s1)($s2)");
	return "gte():ͤǤϤʤޤ";
    }
}

#------------------------------------
# less than
# in  : src1, src2
# out : true,false
#   sr1<src2ΤȤtrue֤뤬ʳʥ顼ޤˤfalse֤
#------------------------------------
sub lt
{
    my (@opland)=@_;
    if (!defined($opland[0]) || !defined($opland[1])){
	&log::add(1, "math::lt", "Ƥޤ");
	return "lt():Ƥޤ";
    }
    my ($s1,$s2)=($opland[0],$opland[1]);
    $s1=&Numeric($s1);
    $s2=&Numeric($s2);
    if(&isnum($s1) && &isnum($s2)){
	if($s1 < $s2){
	    return $TRUE;
	}else{
	    return $FALSE;
	}
    }else{
	&log::add(1, "math::lt", "ͤǤϤʤޤ");
	return "lt():ͤǤϤʤޤ";
    }

}

#------------------------------------
# less equal than
# in  : src1, src2
# out : true,false
#   sr1<=src2ΤȤtrue֤뤬ʳʥ顼ޤˤfalse֤
#------------------------------------
sub lte
{
    my (@opland)=@_;
    if (!defined($opland[0]) || !defined($opland[1])){
	&log::add(1, "math::lte", "Ƥޤ");
	return "lte():Ƥޤ";
    }
    my ($s1,$s2)=($opland[0],$opland[1]);

    $s1=&Numeric($s1);
    $s2=&Numeric($s2);
    if(&isnum($s1) && &isnum($s2)){
	if($s1 <= $s2){
	    return $TRUE;
	}else{
	    return $FALSE;
	}
    }else{
	&log::add(1, "math::lte", "ͤǤϤʤޤ");
	return "lte():ͤǤϤʤޤ";
    }
}

#------------------------------------
# equal
# in  : src1, src2
# out : true,false
#   sr1==src2ΤȤtrue֤뤬ʳʥ顼ޤˤfalse֤
#------------------------------------
sub eq
{
    my (@opland)=@_;
    if (!defined($opland[0]) || !defined($opland[1])){
	&log::add(1, "math::eq", "Ƥޤ");
	return "eq():Ƥޤ";
    }
    my ($s1,$s2)=($opland[0],$opland[1]);

#    $s1=&Numeric($s1); ʸӤ⤢ΤǾά
#    $s2=&Numeric($s2);
    if(&isnum($s1) && &isnum($s2)){
	if($s1 == $s2){
	    return $TRUE;
	}else{
	    return $FALSE;
	}
    }else{
	if($s1 eq $s2){
	    return $TRUE;
	}else{
	    return $FALSE;
	}
    }
}

#------------------------------------
# not equal
# in  : src1, src2
# out : true,false
#   sr1!=src2ΤȤtrue֤뤬ʳʥ顼ޤˤfalse֤
#------------------------------------
sub ne
{
    my (@opland)=@_;
    if (!defined($opland[0]) || !defined($opland[1])){
	&log::add(1, "math::eq", "Ƥޤ");
	return "eq():Ƥޤ";
    }
    my ($s1,$s2)=($opland[0],$opland[1]);

#    $s1=&Numeric($s1); ʸӤ⤢ΤǾά
#    $s2=&Numeric($s2);
    if(&isnum($s1) && &isnum($s2)){
	if($s1 != $s2){
	    return $TRUE;
	}else{
	    return $FALSE;
	}
    }else{
	if($s1 ne $s2){
	    return $TRUE;
	}else{
	    return $FALSE;
	}
    }
}

#------------------------------------
# 
# in  : $condition, $t, $f
# out : if($condition)$t else $f;
#------------------------------------
sub Cmp			# $cmpʤ$t,ʤ$f
{
    my (@opland)=@_;
    if (!defined($opland[0])){
	&log::add(1, "math::cmp(if)", "ʸƤޤ");
	return 0;
    }
    my ($cnd,$t,$f)=@opland;

    if ($cnd){
	return $t;
    }else{
	return $f;
    }
}

#------------------------------------
# 
# in  : $cmp, $t, $f
# out : if($cmp)$t else $f;
#------------------------------------
sub If			# $cmpʤ$t,ʤ$f
{
    my (@opland)=@_;
    return &Cmp(@opland);
}

sub test()
{
    $log::user = "test.jpc.com";

    my @str = qw(1 2 3 ab c 4);
    print "sum: @str\n";
    print &Sum(@str)."\n";
    print "=====================================\n";

    @str = qw(10 0 1);
    print "sum: @str\n";
    print &Sum(@str)."\n";
    print "=====================================\n";


    @str = qw(1 2);
    print "Sub: @str\n";
    print &Sub(@str)."\n";
    print "=====================================\n";

    print "Mul: @str\n";
    print &Mul(@str)."\n";
    print "=====================================\n";

    print "Div: @str\n";
    print &Div(@str)."\n";
    print "=====================================\n";

    print "gt: @str\n";
    print &gt(@str)."\n";
    print "=====================================\n";

    print "gte: @str\n";
    print &gte(@str)."\n";
    print "=====================================\n";

    print "lt: @str\n";
    print &lt(@str)."\n";
    print "=====================================\n";

    print "lte: @str\n";
    print &lte(@str)."\n";
    print "=====================================\n";

    print "eq: @str\n";
    print &eq(@str)."\n";
    print "=====================================\n";

    print "ne: @str\n";
    print &ne(@str)."\n";
    print "=====================================\n";

    @str = (1,0,0);
    print "land: @str\n";
    print &land(@str)."\n";
    print "=====================================\n";

    print "lor: @str\n";
    print &lor(@str)."\n";
    print "=====================================\n";

    @str = ("", 5, 2);
    print "not: @str ܤnot\n";
    print &not(@str)."\n";
    print "=====================================\n";
    exit;

    @str = qw(1 5 2);
    print "Cmp: @str\n";
    print &Cmp(@str)."\n";
    print "=====================================\n";

    print "If: @str\n";
    print &If(@str)."\n";
    print "=====================================\n";
   
   

}

#&test();


1;
