<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2008 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: CreateProject.php,v 1.7 2008/09/29 14:41:37 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * ץȥǥ쥯ȥݡͥȥ饹
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: CreateProject.php,v 1.7 2008/09/29 14:41:37 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class CreateProject
{
    /**
     * ץȥǥ쥯ȥ
     *
     * @access public
     * @param object 󥽡륪֥
     * @param string ץȥǥ쥯ȥ
     * @param string Smartyǥ쥯ȥ
     */
    function trigger(&$cmd, $project_dir, $smarty_dir)
    {
        if (!is_dir($project_dir)) {
            if (!mkdir($project_dir, 0755)) {
                trigger_error("[SyL error] Project directory can't create ({$project_dir})", E_USER_ERROR);
                exit;
            }
        }

        $dirs = array(
          'apps'        => 0755,
          'config'      => 0755,
          'lib'         => 0755,
          'lib/Common'  => 0755,
          'public'      => 0755,
          'var'         => 0755,
          'var/cache'   => 0777,
          'var/logs'    => 0755,
          'var/session' => 0777,
          'var/skel-templates' => 0755,
          'var/smarty'         => 0755,
          'var/syslogs' => 0755,
          'var/upload'  => 0777,
        );

        $files = array(
          'defines.xml'    => 'config/defines.xml',
          'filters.xml'    => 'config/filters.xml',
          'components.xml' => 'config/components.xml',
          'DefaultErrorWeb.php' => 'lib/Common/DefaultErrorWeb.php',
          'Error404.php'  => 'lib/Common/Error404.php',
        );

        foreach ($dirs as $dir => $mode) {
            if (!is_dir($project_dir . $dir)) {
                $cmd->stdout("  -> creating directory {$project_dir}{$dir}");
                mkdir("{$project_dir}{$dir}");
                chmod("{$project_dir}{$dir}", $mode);
            }
        }

        foreach ($files as $file_org => $file_dist) {
            $cmd->stdout("  -> copying file {$project_dir}{$file_dist}");
            switch ($file_org) {
            case 'defines.xml':
                $trans = array(
                  '{{SYL_SMARTY_DIR}}' => $smarty_dir
                );
                $contents = is_file("{$project_dir}var/skel-templates/{$file_org}")
                          ? file_get_contents("{$project_dir}var/skel-templates/{$file_org}")
                          : file_get_contents(SYL_PROJECT_DIR . "/var/skel-templates/{$file_org}");
                $contents = strtr($contents, $trans);
                $fp = fopen($project_dir . $file_dist, 'wb');
                fwrite($fp, $contents);
                fclose($fp);
                break;
            default:
                if (file_exists("{$project_dir}var/skel-templates/{$file_org}")) {
                    copy("{$project_dir}var/skel-templates/{$file_org}", "{$project_dir}{$file_dist}");
                } else {
                    copy(SYL_PROJECT_DIR . "/var/skel-templates/{$file_org}", "{$project_dir}{$file_dist}");
                }
            }
        }

        $dh = opendir(SYL_PROJECT_DIR . '/var/skel-templates/');
        while (($file = readdir($dh)) !== false) {
            if ($file != '.' && $file != '..') {
                $basefile = $file;
                $cmd->stdout("  -> copying file {$project_dir}var/skel-templates/{$file}");
                copy(SYL_PROJECT_DIR . "/var/skel-templates/{$file}", "{$project_dir}var/skel-templates/{$file}");
            }
        }
        closedir($dh);
    }
}

?>
