<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2008 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_WebServiceShoppingItemsearchRequest.php,v 1.1 2008/09/29 14:41:37 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * WEBӥ쥹ݥ󥹥饹Yahoo! Japan - ʸѡ
 */
require_once 'SyL_WebServiceShoppingItemsearchResponse.php';

/**
 * WEBӥꥯȥ饹Yahoo! Japan - ʸѡ
 *
 * ܺ٤ϡYahoo!ǥ٥åѡͥåȥ
 *   http://developer.yahoo.co.jp/
 * ʸ
 *   http://developer.yahoo.co.jp/shopping/itemsearch/V1/itemSearch.html
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_WebServiceShoppingItemsearchRequest.php,v 1.1 2008/09/29 14:41:37 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_WebServiceShoppingItemsearchRequest extends SyL_WebServiceYahoo_co_jpRequest
{
    /**
     * WEBӥСΥۥ̾
     *
     * @access protected
     * @var string
     */
    var $host = 'shopping.yahooapis.jp';
    /**
     * ¹URLѥ
     *
     * @access protected
     * @var string
     */
    var $path = '/ShoppingWebService/V1/itemSearch';
    /**
     * 쥹ݥ󥹥饹̾
     *
     * @access protected
     * @var string
     */
    var $response_class = 'SyL_WebServiceShoppingItemsearchResponse';

    /**
     * Yahoo! JAPANեꥨ(yid)ȥХ塼ޡեꥨ(vc)򥻥åȤ
     *
     * @access public
     * @param string Yahoo! JAPANեꥨ(yid)ޤϥХ塼ޡեꥨ(vc)
     */
    function setAffiliateType($affiliate_type)
    {
        switch ($type) {
        case 'yid':
        case 'vc':
            parent::set('affiliate_type', $affiliate_type);
            break;
        default:
            trigger_error("[SyL error] Invalid `affiliate_type' property ({$affiliate_type}) in `" . __CLASS__ . "' class", E_USER_ERROR);
        }
    }

    /**
     * Yahoo! JAPANեꥨID⤷ϡХ塼ޡեꥨID򥻥åȤ
     *
     * @access public
     * @param string Yahoo! JAPANեꥨID⤷ϡХ塼ޡեꥨID
     */
    function setAffiliateId($affiliate_id)
    {
        parent::set('affiliate_id', $affiliate_id);
    }

    /**
     * JSONPȤƽϤݤΥХåؿ̾򥻥åȤ
     *
     * @access public
     * @param string JSONPȤƽϤݤΥХåؿ̾
     */
    function setCallback($callback)
    {
        parent::set('callback', $callback);
    }

    /**
     * ꡼򥻥åȤ
     *
     * @access public
     * @param string ꡼
     */
    function setQuery($query)
    {
        parent::set('query', $query);
    }

    /**
     * 긡μ򥻥åȤ
     * (all, any, phrase)
     *
     * @access public
     * @param string 긡μ
     */
    function setType($type)
    {
        switch ($type) {
        case 'all':
        case 'any':
            parent::set('type', $type);
            break;
        default:
            trigger_error("[SyL error] Invalid `type' property ({$type}) in `" . __CLASS__ . "' class", E_USER_ERROR);
        }
    }

    /**
     * JANɤ򥻥åȤ
     *
     * @access public
     * @param int JAN
     */
    function setJan($jan)
    {
        if (preg_match('/^\d+$/', $jan)) {
            parent::set('jan', $jan);
        } else {
            trigger_error("[SyL error] Invalid `jan' property ({$jan}) in `" . __CLASS__ . "' class", E_USER_ERROR);
        }
    }

    /**
     * ISBN(ҥ)򥻥åȤ
     *
     * @access public
     * @param int ISBN(ҥ)
     */
    function setIsbn($isbn)
    {
        if (preg_match('/^\d+$/', $isbn)) {
            parent::set('isbn', $isbn);
        } else {
            trigger_error("[SyL error] Invalid `isbn' property ({$isbn}) in `" . __CLASS__ . "' class", E_USER_ERROR);
        }
    }

    /**
     * ƥID򥻥åȤ
     *
     * @access public
     * @param int ƥID
     */
    function setCategoryId($category_id)
    {
        if (preg_match('/^\d+$/', $category_id)) {
            parent::set('category_id', $category_id);
        } else {
            trigger_error("[SyL error] Invalid `category_id' property ({$category_id}) in `" . __CLASS__ . "' class", E_USER_ERROR);
        }
    }

    /**
     * ID򥻥åȤ
     *
     * @access public
     * @param int ID
     */
    function setProductId($product_id)
    {
        if (preg_match('/^\d+$/', $product_id)) {
            parent::set('product_id', $product_id);
        } else {
            trigger_error("[SyL error] Invalid `product_id' property ({$product_id}) in `" . __CLASS__ . "' class", E_USER_ERROR);
        }
    }

    /**
     * ʪID򥻥åȤ
     *
     * @access public
     * @param int ʪID
     */
    function setPersonId($person_id)
    {
        if (preg_match('/^\d+$/', $person_id)) {
            parent::set('person_id', $person_id);
        } else {
            trigger_error("[SyL error] Invalid `person_id' property ({$person_id}) in `" . __CLASS__ . "' class", E_USER_ERROR);
        }
    }

    /**
     * ֥ID򥻥åȤ
     *
     * @access public
     * @param int ֥ID
     */
    function setBrandId($brand_id)
    {
        if (preg_match('/^\d+$/', $brand_id)) {
            parent::set('brand_id', $brand_id);
        } else {
            trigger_error("[SyL error] Invalid `brand_id' property ({$brand_id}) in `" . __CLASS__ . "' class", E_USER_ERROR);
        }
    }

    /**
     * ȥID򥻥åȤ
     *
     * @access public
     * @param string ȥID
     */
    function setStoreId($store_id)
    {
        parent::set('store_id', $store_id);
    }

    /**
     * ʻ()ʰʾ򥻥åȤ
     *
     * @access public
     * @param int ʻ()ʰʾ
     */
    function setPriceFrom($price_from)
    {
        if (preg_match('/^\d+$/', $price_from)) {
            parent::set('price_from', $price_from);
        } else {
            trigger_error("[SyL error] Invalid `price_from' property ({$price_from}) in `" . __CLASS__ . "' class", E_USER_ERROR);
        }
    }

    /**
     * ʻ(ǹ)̤򥻥åȤ
     *
     * @access public
     * @param int ʻ(ǹ)̤
     */
    function setPriceTo($price_to)
    {
        if (preg_match('/^\d+$/', $price_to)) {
            parent::set('price_to', $price_to);
        } else {
            trigger_error("[SyL error] Invalid `price_to' property ({$price_to}) in `" . __CLASS__ . "' class", E_USER_ERROR);
        }
    }

    /**
     * 븡̿򥻥åȤ
     *
     * @access public
     * @param int 븡̿
     */
    function setHits($hits)
    {
        if (preg_match('/^\d+$/', $hits) && (($hits >= 0) && ($hits <= 50))) {
            parent::set('hits', $hits);
        } else {
            trigger_error("[SyL error] Invalid `hits' property ({$hits}) in `" . __CLASS__ . "' class", E_USER_ERROR);
        }
    }

    /**
     * ܤɽ뤫򥻥åȤ
     *
     * @access public
     * @param int ܤɽ뤫
     */
    function setOffset($offset)
    {
        if (preg_match('/^\d+$/', $offset)) {
            parent::set('offset', $offset);
        } else {
            trigger_error("[SyL error] Invalid `offset' property ({$offset}) in `" . __CLASS__ . "' class", E_USER_ERROR);
        }
    }

    /**
     * եμ򥻥åȤ
     *
     * @access public
     * @param string եμ
     */
    function setSort($sort)
    {
        switch ($sort) {
        case 'price': // ʲ
        case 'name':  // ȥ̾
        case 'score': // 
        case 'sold':  // ڽ
            parent::set('sort', $sort);
            break;
        default:
            trigger_error("[SyL error] Invalid `sort' property ({$sort}) in `" . __CLASS__ . "' class", E_USER_ERROR);
        }
    }

    /**
     * ֥ƥȥ֥ƥ˴ޤޤ뾦ʿΥꥹȤμ򥻥åȤ
     *
     * @access public
     * @param string ֥ƥȥ֥ƥ˴ޤޤ뾦ʿΥꥹȤμ
     */
    function setModule($module)
    {
        switch ($module) {
        case 'priceranges':
        case 'subcategories':
            parent::set('module', $module);
            break;
        default:
            trigger_error("[SyL error] Invalid `module' property ({$module}) in `" . __CLASS__ . "' class", E_USER_ERROR);
        }
    }

    /**
     * ߸˹ʤߤ򥻥åȤ
     *
     * @access public
     * @param int ߸˹ʤ
     */
    function setAvailability($availability)
    {
        if ($availability == '1') {
            parent::set('availability', $availability);
        } else {
            trigger_error("[SyL error] Invalid `availability' property ({$availability}) in `" . __CLASS__ . "' class", E_USER_ERROR);
        }
    }

    /**
     * 澦ʹʤߤ򥻥åȤ
     *
     * @access public
     * @param int 澦ʹʤ
     */
    function setDiscount($discount)
    {
        if ($discount == '1') {
            parent::set('discount', $discount);
        } else {
            trigger_error("[SyL error] Invalid `discount' property ({$discount}) in `" . __CLASS__ . "' class", E_USER_ERROR);
        }
    }

    /**
     * ̵򥻥åȤ
     *
     * @access public
     * @param int ̵
     */
    function setShipping($shipping)
    {
        if ($shipping == '1') {
            parent::set('shipping', $shipping);
        } else {
            trigger_error("[SyL error] Invalid `shipping' property ({$shipping}) in `" . __CLASS__ . "' class", E_USER_ERROR);
        }
    }

}

?>
