<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2008 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_WebServiceMinnaCertCertListRequest.php,v 1.3 2008/09/11 13:06:59 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * WEBӥ쥹ݥ󥹥饹Yahoo! Japan - ߤʤθ ꥹWebӥ
 */
require_once 'SyL_WebServiceMinnaCertCertListResponse.php';

/**
 * WEBӥꥯȥ饹Yahoo! Japan - ߤʤθ ꥹWebӥ
 *
 * ܺ٤ϡYahoo!ǥ٥åѡͥåȥ
 *   http://developer.yahoo.co.jp/
 * ߤʤθ ꥹWebӥ
 *   http://developer.yahoo.co.jp/minna_cert/certlist/V1/certlist.html
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_WebServiceMinnaCertCertListRequest.php,v 1.3 2008/09/11 13:06:59 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_WebServiceMinnaCertCertListRequest extends SyL_WebServiceYahoo_co_jpRequest
{
    /**
     * WEBӥСΥۥ̾
     *
     * @access protected
     * @var string
     */
    var $host = 'cert.yahooapis.jp';
    /**
     * ¹URLѥ
     *
     * @access protected
     * @var string
     */
    var $path = '/MinnaCertWebService/V1/certList';
    /**
     * 쥹ݥ󥹥饹̾
     *
     * @access protected
     * @var string
     */
    var $response_class = 'SyL_WebServiceMinnaCertCertListResponse';

    /**
     * ѼԤбURLʸ򥻥åȤ
     *
     * @access public
     * @param string ѼԤбURLʸ
     */
    function setUserstr($userstr)
    {
        parent::set('userstr', $userstr);
    }

    /**
     * ꡼򥻥åȤ
     *
     * @access public
     * @param string ꡼
     */
    function setKeyword($keyword)
    {
        parent::set('keyword', $keyword);
    }

    /**
     * ̤򥻥åȤ
     *
     * @access public
     * @param int 
     */
    function setExtract($extract)
    {
        switch ((string)$extract) {
        case '0': // ɸ
        case '1': // 
            parent::set('extract', $extract);
            break;
        default:
            trigger_error("[SyL error] Invalid `extract' property ({$extract}) in `" . __CLASS__ . "' class", E_USER_ERROR);
        }
    }

    /**
     * ¤ؤ򥻥åȤ
     *
     * @access public
     * @param int ¤ؤ
     */
    function setOrder($order)
    {
        switch ((string)$order) {
        case '1': // ߽
        case '2': // ݥ
        case '3': // Կ
        case '4': // ̾
            parent::set('order', $order);
            break;
        default:
            trigger_error("[SyL error] Invalid `order' property ({$order}) in `" . __CLASS__ . "' class", E_USER_ERROR);
        }
    }

    /**
     * ֵѷ̤Ƭ֤򥻥åȤ
     *
     * @access public
     * @param int ֵѷ̤Ƭ
     */
    function setStart($start)
    {
        if (preg_match('/^\d+$/', $start) && ($start >= 1)) {
            parent::set('start', $start);
        } else {
            trigger_error("[SyL error] Invalid `start' property ({$start}) in `" . __CLASS__ . "' class", E_USER_ERROR);
        }
    }

    /**
     * ֵѷ̤ο򥻥åȤ
     *
     * @access public
     * @param int ֵѷ̤ο
     */
    function setAmount($amount)
    {
        if (preg_match('/^\d+$/', $amount) && (($amount >= 1) && ($amount <= 50))) {
            parent::set('amount', $amount);
        } else {
            trigger_error("[SyL error] Invalid `amount' property ({$amount}) in `" . __CLASS__ . "' class", E_USER_ERROR);
        }
    }
}

?>
