<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2008 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_WebServiceMinnaCertCertExamResponse.php,v 1.3 2008/09/29 14:41:37 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * WEBӥ쥹ݥ󥹥饹Yahoo! Japan - ߤʤθ Webӥ
 *
 * ܺ٤ϡYahoo!ǥ٥åѡͥåȥ
 *   http://developer.yahoo.co.jp/
 * ߤʤθ Webӥ
 *   http://developer.yahoo.co.jp/minna_cert/certexam/V1/certexam.html
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_WebServiceMinnaCertCertExamResponse.php,v 1.3 2008/09/29 14:41:37 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_WebServiceMinnaCertCertExamResponse extends SyL_WebServiceYahoo_co_jpResponse
{
    /**
     * ǡ
     *
     * @access private
     * @var array
     */
    var $result = array();
    /**
     * ɾǡ
     *
     * @access private
     * @var array
     */
    var $result_eval = array();
    /**
     * ɾܺ٥ǡ
     *
     * @access private
     * @var array
     */
    var $result_evals = array();

    /**
     * XMLǡƼϥɥ᥽å
     *
     * @access protected
     * @param string XMLΥѥ
     * @param string XMLΥ°
     * @param string XMLΥ
     */
    function getElement($current_path, $attribute, $text)
    {
        static $i   = -1;
        static $q_i = -1;

        switch ($current_path) {
        // =============================
        // 
        // =============================
        // ID
        case '/ResultSet/Result/CertId': $this->result['CertId'] = $text; break;
        // ̾
        case '/ResultSet/Result/CertName': $this->result['CertName'] = $text; break;
        // URL
        case '/ResultSet/Result/CertImageUrl': $this->result['CertImageUrl'] = $text; break;
        // 공
        case '/ResultSet/Result/CertOverview': $this->result['CertOverview'] = $text; break;
        // ʬ
        case '/ResultSet/Result/CertDiv': $this->result['CertDiv'] = $text; break;
        // ̾
        case '/ResultSet/Result/UserName': $this->result['UserName'] = $text; break;
        // ѥǤθܺ٥ڡURL
        case '/ResultSet/Result/CertDetailPcUrl': $this->result['CertDetailPcUrl'] = $text; break;
        // ХǤθܺ٥ڡURL
        case '/ResultSet/Result/CertDetailMbUrl': $this->result['CertDetailMbUrl'] = $text; break;

        //
        case '/ResultSet/Result/EvalResult/EvalAxis': $this->result_eval['EvalAxis'] = $text; break;
        // ɾȥ
        case '/ResultSet/Result/EvalResult/EvalTitle': $this->result_eval['EvalTitle'] = $text; break;
        // ɾå
        case '/ResultSet/Result/EvalResult/EvalMessage': $this->result_eval['EvalMessage'] = $text; break;
        // 
        case '/ResultSet/Result/EvalResult/Passing': $this->result_eval['Passing'] = $text; break;
        // ݥ
        case '/ResultSet/Result/EvalResult/Score': $this->result_eval['Score'] = $text; break;

        case '/ResultSet/Result/EvalDetailResult/EvalDetailData': $i++; break;
        // ID
        case '/ResultSet/Result/EvalDetailResult/EvalDetailData/QuestionId': $this->result_evals[$i]['QuestionId'] = $text; break;
        // ֹ
        case '/ResultSet/Result/EvalDetailResult/EvalDetailData/OrderNumber': $this->result_evals[$i]['OrderNumber'] = $text; break;
        // ʸ
        case '/ResultSet/Result/EvalDetailResult/EvalDetailData/QuestionText': $this->result_evals[$i]['QuestionText'] = $text; break;
        // MˤURL
        case '/ResultSet/Result/EvalDetailResult/EvalDetailData/QuestionImageMUrl': $this->result_evals[$i]['QuestionImageMUrl'] = $text; break;
        // SˤURL
        case '/ResultSet/Result/EvalDetailResult/EvalDetailData/QuestionImageSUrl': $this->result_evals[$i]['QuestionImageSUrl'] = $text; break;
        // ưURL
        case '/ResultSet/Result/EvalDetailResult/EvalDetailData/QuestionMoveUrl': $this->result_evals[$i]['QuestionMoveUrl'] = $text; break;

        // 򤷤ͤ
        case '/ResultSet/Result/EvalDetailResult/EvalDetailData/CorrectCount': $this->result_evals[$i]['CorrectCount'] = $text; break;
        // ̤Ȥͤ
        case '/ResultSet/Result/EvalDetailResult/EvalDetailData/NoAnswerCount': $this->result_evals[$i]['NoAnswerCount'] = $text; break;
        // ֹ
        case '/ResultSet/Result/EvalDetailResult/EvalDetailData/CorrectAnswer': $this->result_evals[$i]['CorrectAnswer'] = $text; break;
        // ʸ
        case '/ResultSet/Result/EvalDetailResult/EvalDetailData/QuestionExplanation': $this->result_evals[$i]['QuestionExplanation'] = $text; break;
        // MˤURL
        case '/ResultSet/Result/EvalDetailResult/EvalDetailData/ExplanationImageMUrl': $this->result_evals[$i]['ExplanationImageMUrl'] = $text; break;
        // SˤURL
        case '/ResultSet/Result/EvalDetailResult/EvalDetailData/ExplanationImageSUrl': $this->result_evals[$i]['ExplanationImageSUrl'] = $text; break;
        // ưURL
        case '/ResultSet/Result/EvalDetailResult/EvalDetailData/ExplanationMovieUrl': $this->result_evals[$i]['ExplanationMovieUrl'] = $text; break;
        // Ԥ򤷤ֹ
        case '/ResultSet/Result/EvalDetailResult/EvalDetailData/Answer': $this->result_evals[$i]['Answer'] = $text; break;
        // /
        case '/ResultSet/Result/EvalDetailResult/EvalDetailData/Correct': $this->result_evals[$i]['Correct'] = $text; break;

        // 
        case '/ResultSet/Result/EvalDetailResult/EvalDetailData/ChoicesResult':
            $this->result_evals[$i]['ChoicesResult'] = array();
            $q_i = -1;
            break;
        // ƾ
        case '/ResultSet/Result/EvalDetailResult/EvalDetailData/ChoicesResult/ChoiceData': $q_i++; break;
        // ֹ
        case '/ResultSet/Result/EvalDetailResult/EvalDetailData/ChoicesResult/ChoiceData/OrderNumber': $this->result_evals[$i]['ChoicesResult'][$q_i]['OrderNumber'] = $text; break;
        // 
        case '/ResultSet/Result/EvalDetailResult/EvalDetailData/ChoicesResult/ChoiceData/ChoiceText': $this->result_evals[$i]['ChoicesResult'][$q_i]['ChoiceText'] = $text; break;
        // ˳꿶Ƥݥ
        case '/ResultSet/Result/EvalDetailResult/EvalDetailData/ChoicesResult/ChoiceData/ChoicePoint': $this->result_evals[$i]['ChoicesResult'][$q_i]['ChoicePoint'] = $text; break;
        // Կ
        case '/ResultSet/Result/EvalDetailResult/EvalDetailData/ChoicesResult/ChoiceData/ChoiceCount': $this->result_evals[$i]['ChoicesResult'][$q_i]['ChoiceCount'] = $text; break;

        // ¾
        default: parent::getElement($current_path, $attribute, $text); break;
        }
    }

    /**
     * ǡΥޥå꡼
     *
     * @access public
     * @return int ǡΥޥå꡼
     */
    function getTotalResultsAvailable()
    {
        return $this->total_results_available;
    }

    /**
     * ֵѤ졢ĥޥå꡼ο
     *
     * @access public
     * @return int ֵѤ졢ĥޥå꡼ο
     */
    function getTotalResultsReturned()
    {
        return $this->total_results_returned;
    }

    /**
     * ֵѤ졢ĥޥå꡼ο
     *
     * @access public
     * @return int ֵѤ졢ĥޥå꡼ο
     */
    function getFirstResultPosition()
    {
        return $this->first_result_position;
    }

    /**
     * ǡ
     *
     * @access public
     * @return array ǡ
     */
    function getResult()
    {
        return $this->result;
    }

    /**
     * ɾǡ
     *
     * @access public
     * @return array ɾǡ
     */
    function getEval()
    {
        return $this->result_eval;
    }

    /**
     * ɾܺ٥ǡ
     *
     * @access public
     * @return array ɾܺ٥ǡ
     */
    function getEvals()
    {
        return $this->result_evals;
    }
}

?>
