<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2008 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_WebServiceCategorySearchResponse.php,v 1.1 2008/09/11 13:06:59 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * WEBӥ쥹ݥ󥹥饹Yahoo! Japan - ǥ쥯ȥꥵѡ
 *
 * ܺ٤ϡYahoo!ǥ٥åѡͥåȥ
 *   http://developer.yahoo.co.jp/
 * ǥ쥯ȥꥵ
 *   http://developer.yahoo.co.jp/category/search/V1/search.html
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_WebServiceCategorySearchResponse.php,v 1.1 2008/09/11 13:06:59 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_WebServiceCategorySearchResponse extends SyL_WebServiceYahoo_co_jpResponse
{
    /**
     * 쥹ݥ󥹤ξ֤䥵СΥå
     *
     * @access private
     * @var array
     */
     var $status = array();
    /**
     * ƥ°
     *
     * @access private
     * @var array
     */
    var $category_property = array();
    /**
     * ƥθ̤ν
     *
     * @access private
     * @var array
     */
    var $category = array();
    /**
     * °
     *
     * @access private
     * @var int
     */
    var $site_property = array();
    /**
     * Ͽȸ̤ν
     *
     * @access private
     * @var array
     */
    var $site = array();

    /**
     * XMLǡƼϥɥ᥽å
     *
     * @access protected
     * @param string XMLΥѥ
     * @param string XMLΥ°
     * @param string XMLΥ
     */
    function getElement($current_path, $attribute, $text)
    {
        static $item_i = -1;
        static $site_i = -1;

        switch ($current_path) {
        // APIϤ줿ѥ᡼ν
        case '/ResultSet/Status/Args/Arg': $this->status[$attribute['Name']] = $attribute['Value']; break;

        // =============================
        // 顼
        // =============================
        // 顼Ƚ
        case '/ResultSet/Status/Errors': $this->error = true; break;
        case '/ResultSet/Status/Errors/Error': $this->error_message .= $text; break;

        // =============================
        // 
        // =============================
        // ƥ
        case '/ResultSet/DirSearchResults': $this->category_property = $attribute; break;
        // ƥItem
        case '/ResultSet/DirSearchResults/Item': $item_i++; break;

        // ƥID
        case '/ResultSet/DirSearchResults/Item/Id': $this->category[$item_i]['Id'] = $text; break;
        // ƥ꥿
        case '/ResultSet/DirSearchResults/Item/Type': $this->category[$item_i]['Type'] = $text; break;
        // ƥ̾
        case '/ResultSet/DirSearchResults/Item/Title': $this->category[$item_i]['Title'] = $text; break;
        // Yahoo! JAPAN󶡤Yahoo!ƥΥڡURL顢http://dir.yahoo.co.jp/פ
        case '/ResultSet/DirSearchResults/Item/Path': $this->category[$item_i]['Path'] = $text; break;
        // ƥڡURL
        case '/ResultSet/DirSearchResults/Item/Url': $this->category[$item_i]['Url'] = $text; break;
        // ƥڡؤΥѡʥåѡURL
        case '/ResultSet/DirSearchResults/Item/ClickUrl': $this->category[$item_i]['ClickUrl'] = $text; break;
        // Yahoo! JAPAN󶡤Yahoo!ƥΡڡΡ֥ƥѥBreadcrumbˡ
        case '/ResultSet/DirSearchResults/Item/JPath': $this->category[$item_i]['JPath'] = $text; break;
        // ƥ꤬줿
        case '/ResultSet/DirSearchResults/Item/Created': $this->category[$item_i]['Created'] = $text; break;
        // ȥƥξ
        case '/ResultSet/DirSearchResults/Item/Adult': $this->category[$item_i]['Adult'] = $text; break;
        // 1ְ˿Ͽ줿ƥξ
        case '/ResultSet/DirSearchResults/Item/New': $this->category[$item_i]['New'] = $text; break;

        // Ͽ
        case '/ResultSet/SiteSearchResults': $this->site_property = $attribute; break;
        // ϿItem
        case '/ResultSet/SiteSearchResults/Item': $site_i++; break;

        // ȤϿƤ륫ƥID
        case '/ResultSet/SiteSearchResults/Item/Parent': $this->site[$site_i]['Parent'] = $text; break;
        // ȤϿƤ륫ƥΥƥ̾
        case '/ResultSet/SiteSearchResults/Item/ParentName': $this->site[$site_i]['ParentName'] = $text; break;
        // ȤϿƤ륫ƥڡURL
        case '/ResultSet/SiteSearchResults/Item/ParentCategoryUrl': $this->site[$site_i]['ParentCategoryUrl'] = $text; break;
        // ȤϿƤ륫ƥڡؤΥѡʥåѡURL
        case '/ResultSet/SiteSearchResults/Item/ParentCategoryClickUrl': $this->site[$site_i]['ParentCategoryClickUrl'] = $text; break;
        // ȥ
        case '/ResultSet/SiteSearchResults/Item/Type': $this->site[$site_i]['Type'] = $text; break;
        // Ͽ̾
        case '/ResultSet/SiteSearchResults/Item/Title': $this->site[$site_i]['Title'] = $text; break;
        // ϿȤ
        case '/ResultSet/SiteSearchResults/Item/Summary': $this->site[$site_i]['Summary'] = $text; break;
        // ϿȤURL
        case '/ResultSet/SiteSearchResults/Item/Url': $this->site[$site_i]['Url'] = $text; break;
        // ϿȤؤΥѡʥåѡURL
        case '/ResultSet/SiteSearchResults/Item/ClickUrl': $this->site[$site_i]['ClickUrl'] = $text; break;
        // ȤϿ줿
        case '/ResultSet/SiteSearchResults/Item/Created': $this->site[$site_i]['Created'] = $text; break;
        // ȥȤξ
        case '/ResultSet/SiteSearchResults/Item/Adult': $this->site[$site_i]['Adult'] = $text; break;
        // 1ְ˿Ͽ줿Ȥξ
        case '/ResultSet/SiteSearchResults/Item/New': $this->site[$site_i]['New'] = $text; break;
        // ֿפΡֺΥפ˷Ǻܤ줿Ȥξ
        case '/ResultSet/SiteSearchResults/Item/Picks': $this->site[$site_i]['Picks'] = $text; break;
        // Yahoo!ƥȼδˤäơͥ줿ƤǤɾ줿Ȥξ
        case '/ResultSet/SiteSearchResults/Item/Cool': $this->site[$site_i]['Cool'] = $text; break;

        // ¾
        default: parent::getElement($current_path, $attribute, $text); break;
        }
    }

    /**
     * 쥹ݥ󥹤ξ֤䥵СΥå
     *
     * @access public
     * @param string 
     * @return mixed 쥹ݥ󥹤ξ֤䥵СΥå
     */
    function getStatus($name=null)
    {
        if ($name !== null) {
            return isset($this->status[$name]) ? $this->status[$name] : null;
        } else {
            return $this->status;
        }
    }

    /**
     * ƥθ̿
     *
     * @access public
     * @return int ƥθ̿
     */
    function getCategoryCount()
    {
        return isset($this->category_property['Count']) ? $this->category_property['Count'] : 0;
    }

    /**
     * ƥθ̤
     *
     * @access public
     * @return int ƥθ̤
     */
    function getCategoryTotalCount()
    {
        return isset($this->category_property['TotalCount']) ? $this->category_property['TotalCount'] : 0;
    }

    /**
     * ̤μϰ֤
     *
     * @access public
     * @return int ̤μϰ
     */
    function getCategoryStart()
    {
        return isset($this->category_property['Start']) ? $this->category_property['Start'] : 0;
    }

    /**
     * ƥǡ
     *
     * @access public
     * @return array ƥǡ
     */
    function getCategory()
    {
        return $this->category;
    }

    /**
     * Ȥθ̿
     *
     * @access public
     * @return int ƥθ̿
     */
    function getSiteCount()
    {
        return isset($this->site_property['Count']) ? $this->site_property['Count'] : 0;
    }

    /**
     * Ȥθ̤
     *
     * @access public
     * @return int ƥθ̤
     */
    function getSiteTotalCount()
    {
        return isset($this->site_property['TotalCount']) ? $this->site_property['TotalCount'] : 0;
    }

    /**
     * Ȥη̤μϰ֤
     *
     * @access public
     * @return int Ȥη̤μϰ
     */
    function getSiteStart()
    {
        return isset($this->site_property['Start']) ? $this->site_property['Start'] : 0;
    }

    /**
     * ȥǡ
     *
     * @access public
     * @return array ȥǡ
     */
    function getSite()
    {
        return $this->site;
    }
}

?>
