<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2008 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_WebServiceMarketGenreSearchRequest.php,v 1.1 2008/03/01 05:01:22 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * WEBӥ쥹ݥ󥹥饹ʳŷ - ŷ븡APIѡ
 */
require_once 'SyL_WebServiceMarketGenreSearchResponse.php';

/**
 * WEBӥ饹ʳŷ - ŷ븡APIѡ
 *
 * ܺ٤ϡŷ֥ӥ󥿡
 *   http://webservice.rakuten.co.jp/
 * ŷ븡API 
 *   http://webservice.rakuten.co.jp/api/genresearch/
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_WebServiceMarketGenreSearchRequest.php,v 1.1 2008/03/01 05:01:22 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_WebServiceMarketGenreSearchRequest extends SyL_WebServiceRakuten_co_jpRequest
{
    /**
     * ¹URLѥ
     *
     * @access protected
     * @var string
     */
    var $path = '/rws/1.11/rest';
    /**
     * 쥹ݥ󥹥饹̾
     *
     * @access protected
     * @var string
     */
    var $response_class = 'SyL_WebServiceMarketGenreSearchResponse';

    /**
     * ID򥻥åȤ
     *
     * @access public
     * @param int ID
     */
    function setGenreId($genreId)
    {
        if (preg_match('/^\d+$/', $genreId)) {
            parent::set('genreId', $genreId);
        } else {
            trigger_error("[SyL error] Invalid `genreId' property ({$genreId}) in `" . __CLASS__ . "' class", E_USER_ERROR);
        }
    }

    /**
     * С򥻥åȤ
     *
     * @access public
     * @param string С
     */
    function setVersion($version)
    {
        parent::set('version', $version);
    }

    /**
     * ѥ򥻥åȤ
     *
     * @access public
     * @param int ѥ
     */
    function setGenrePath($genrePath)
    {
        switch ((string)$genrePath) {
        case '0':
        case '1':
            parent::set('genrePath', $genrePath);
            break;
        default:
            trigger_error("[SyL error] Invalid `genrePath' property ({$genrePath}) in `" . __CLASS__ . "' class", E_USER_ERROR);
        }
    }
}

?>
