<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2008 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_Mail.php,v 1.19 2008/09/23 09:06:15 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * ᡼å饹
 */
require_once dirname(__FILE__) . '/Mail/SyL_MailMessage.php';

/**
 * ᡼륯饹
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_Mail.php,v 1.19 2008/09/23 09:06:15 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_Mail
{
    /**
     * ᡼륵СΥۥ̾
     *
     * @access protected
     * @var string
     */
    var $host = 'localhost';
    /**
     * ᡼륵СΥݡ
     *
     * @access protected
     * @var int
     */
    var $port = '';
    /**
     * 桼̾
     *
     * @access protected
     * @var string
     */
    var $user = '';
    /**
     * ѥ
     *
     * @access protected
     * @var string
     */
    var $passwd = '';
    /**
     * ᡼ƤΥ󥳡
     * 
     * @access protected
     * @var string
     */
    var $mail_encode = 'ISO-2022-JP';
    /**
     * ץ¦Υ󥳡
     * 
     * @access protected
     * @var string
     */
    var $internal_encode = '';
    /**
     * 
     * 
     * @access protected
     * @var string
     */
    var $language = 'ja';
    /**
     * 顼å
     * 
     * @access protected
     * @var string
     */
    var $error_message = '';

    /**
     * 󥹥ȥ饯
     * 
     * @access public
     */
    function SyL_Mail()
    {
        $language = mb_language();
        if ($language) {
            $this->language = $language;
        }
        $this->internal_encode = mb_internal_encoding();
    }

    /**
     * ᡼饹Υ󥹥󥹼
     *
     * @static
     * @access public
     * @param string ᡼
     * @return object ᡼֥
     */
    function &factorySend($mail_string='default')
    {
        include_once dirname(__FILE__) . '/Mail/SyL_MailSend.php';

        $mail_strings = explode(':', $mail_string, 2);
        $class_name = 'SyL_MailSend' . ucfirst($mail_strings[0]);
        include_once dirname(__FILE__) . '/Mail/Send/' . $class_name . '.php';
        $mail = new $class_name();
        if (isset($mail_strings[1])) {
            foreach (explode(';', $mail_strings[1]) as $tmp) {
                if (strpos($tmp, '=') !== false) {
                    list($method, $value) = explode('=', $tmp, 2);
                    $method = 'set' . ucfirst($method);
                    $mail->$method($value);
                }
            }
        }
        return $mail;
    }

    /**
     * ᡼饹Υ󥹥󥹼
     *
     * @static
     * @access public
     * @param string ᡼
     * @return object ᡼֥
     */
    function &factoryReceive($mail_string='Pop3')
    {
        include_once dirname(__FILE__) . '/Mail/SyL_MailReceive.php';

        $mail_strings = explode(':', $mail_string, 2);
        $class_name = 'SyL_MailReceive' . ucfirst($mail_strings[0]);
        include_once dirname(__FILE__) . '/Mail/Receive/' . $class_name . '.php';
        $mail = new $class_name();
        if (isset($mail_strings[1])) {
            foreach (explode(';', $mail_strings[1]) as $tmp) {
                if (strpos($tmp, '=') !== false) {
                    list($method, $value) = explode('=', $tmp, 2);
                    $method = 'set' . ucfirst($method);
                    $mail->$method($value);
                }
            }
        }
        return $mail;
    }

    /**
     * ᡼å֥Ȥ
     * 
     * @access public
     * @return object ᡼å֥
     */
    function &createMessage()
    {
        $message =& new SyL_MailMessage();
        $message->setMailEncode($this->mail_encode);
        $message->setInternalEncode($this->internal_encode);
        $message->setLanguage($this->language);
        return $message;
    }

    /**
     * ۥ̾򥻥åȤ
     *
     * @access public
     * @param string ۥ̾
     */
    function setHost($host)
    {
        $this->host = $host;
    }

    /**
     * ݡֹ򥻥åȤ
     *
     * @access public
     * @param string ݡֹ
     */
    function setPort($port)
    {
        $this->port = $port;
    }

    /**
     * 桼̾򥻥åȤ
     *
     * @access public
     * @param string 桼̾
     */
    function setUser($user)
    {
        $this->user = $user;
    }

    /**
     * ѥɤ򥻥åȤ
     *
     * @access public
     * @param string ѥ
     */
    function setPasswd($passwd)
    {
        $this->passwd = $passwd;
    }

    /**
     * ᡼륨󥳡ɤ򥻥åȤ
     *
     * @access public
     * @param string ᡼륨󥳡
     */
    function setMailEncode($mail_encode)
    {
        $this->mail_encode = $mail_encode;
    }

    /**
     * ѥ᡼󥳡ɤ򥻥åȤ
     *
     * @access public
     * @param string ѥ᡼󥳡
     */
    function setInternalEncode($internal_encode)
    {
        $this->internal_encode = $internal_encode;
    }

    /**
     * 򥻥åȤ
     *
     * @access public
     * @param string 
     */
    function setLanguage($language)
    {
        $this->language = $language;
    }

    /**
     * 顼åȽ
     *
     * @access public
     * @return string 顼å
     */
    function isError()
    {
        return ($this->error_message != '');
    }

    /**
     * 顼å
     *
     * @access public
     * @return string 顼å
     */
    function getErrorMessage()
    {
        return $this->error_message;
    }
}

?>
