<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2008 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_Filesystem.php,v 1.5 2008/09/23 09:06:15 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

clearstatcache();

/**
 * t@CVXẽfBNgNX
 */
require_once dirname(__FILE__) . '/Filesystem/SyL_FilesystemDirectory.php';
/**
 * t@CVXẽt@CNX
 */
require_once dirname(__FILE__) . '/Filesystem/SyL_FilesystemFile.php';
/**
 * sNX
 */
require_once dirname(__FILE__) . '/Util/SyL_UtilEnv.php';

/**
 * t@CVXeNX
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_Filesystem.php,v 1.5 2008/09/23 09:06:15 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_Filesystem
{
    /**
     * vf
     *
     * @access protected
     * @var string
     */
    var $file = '';
    /**
     * vf^Cv
     *
     * @access protected
     * @var string
     */
    var $type = '';
    /**
     * vf̃^f[^
     *
     * @access protected
     * @var array
     */
    var $stat = array();

    /**
     * RXgN^
     *
     * @access public
     * @param string vfi΃pXj
     */
    function SyL_Filesystem($file)
    {
        if (preg_match('/^(.+)(\\\\|\/)$/', $file)) {
            $file = substr($file, 0, -1);
        }
        // t@CZbg
        $this->file = $file;
        // t@C^Cv
        $this->type = filetype($file);
        // vf擾
        $this->stat = stat($file);
    }

    /**
     * vfIuWFNg擾
     *
     * @static
     * @access public
     * @param string vfi΃pXj
     */
    function &factory($file)
    {
        if (!file_exists($file)) {
            trigger_error("[SyL error] File not found ({$file})", E_USER_ERROR);
        }

        $file = realpath($file);

        $element = null;
        if (is_dir($file)) {
           $element =& new SyL_FilesystemDirectory($file);
        } else {
           $element =& new SyL_FilesystemFile($file);
        }
        return $element;
    }

    /**
     * fBNg
     *
     * @access abstract
     * @return bool true: fBNgAfalse: fBNgȊO
     */
    function isDir()
    {
    }

    /**
     * ݔ
     *
     * @access public
     * @return bool true: fBNgAfalse: fBNgȊO
     */
    function isWritable()
    {
        return is_writable($this->file);
    }

    /**
     * vf擾
     *
     * @access public
     * @param bool vf̂ݎ擾tO
     * @return string vf
     */
    function getName($name_only=false)
    {
        return ($name_only) ? basename($this->file) : $this->file;
    }

    /**
     * vf^Cv擾
     *
     * @access public
     * @return string vf^Cv
     */
    function getType()
    {
        return $this->type;
    }

    /**
     * vf̃^f[^擾
     *
     * @access public
     * @param string vf
     * @return mixed vfl
     */
    function getStat($name)
    {
        return isset($this->stat[$name]) ? $this->stat[$name] : null;
    }

    /**
     * TCY擾
     *
     * @access protected
     * @return int TCY
     */
    function getSize()
    {
        return isset($this->stat['size']) ? $this->stat['size'] : null;
    }

    /**
     * ŏIXV擾
     *
     * @access public
     * @return string ŏIXV
     */
    function getMtime()
    {
        return isset($this->stat['mtime']) ? $this->stat['mtime'] : null;
    }

    /**
     * vf̏LҖ擾
     *
     * @access public
     * @return string LҖ
     */
    function getOwner()
    {
        return isset($this->stat['uid']) ? SyL_UtilEnv::getOsUser($this->stat['uid']) : null;
    }

    /**
     * p[~bV𐮌`
     *
     * @access public
     * @param int p[~bV
     * @param bool 8i擾tO
     * @return string `̃p[~bV
     */
    function getPermission($numeric=true)
    {
        $perm = null;
        if (isset($this->stat['mode'])) {
            $perm = $this->stat['mode'];
        } else {
            return null;
        }

        if ($numeric) {
            return substr(sprintf('%o', $perm), -4);
        } else {
            $info  = '';
            if (($perm & 0xC000) == 0xC000) {
                $info = 's'; // \Pbg
            } else if (($perm & 0xA000) == 0xA000) {
                $info = 'l'; // V{bNN
            } else if (($perm & 0x8000) == 0x8000) {
                $info = '-'; // ʏ̃t@C
            } else if (($perm & 0x6000) == 0x6000) {
                $info = 'b'; // ubNXyVt@C
            } else if (($perm & 0x4000) == 0x4000) {
                $info = 'd'; // fBNg
            } else if (($perm & 0x2000) == 0x2000) {
                $info = 'c'; // LN^XyVt@C
            } else if (($perm & 0x1000) == 0x1000) {
                $info = 'p'; // FIFO pCv
            } else {
                $info = 'u'; // s
            }

            // L
            $info .= ($perm & 0x0100) ? 'r' : '-';
            $info .= ($perm & 0x0080) ? 'w' : '-';
            $info .= ($perm & 0x0040)
                   ? (($perm & 0x0800) ? 's' : 'x')
                   : (($perm & 0x0800) ? 'S' : '-');
            // O[v
            $info .= ($perm & 0x0020) ? 'r' : '-';
            $info .= ($perm & 0x0010) ? 'w' : '-';
            $info .= ($perm & 0x0008)
                   ? (($perm & 0x0400) ? 's' : 'x')
                   : (($perm & 0x0400) ? 'S' : '-');
            // S
            $info .= ($perm & 0x0004) ? 'r' : '-';
            $info .= ($perm & 0x0002) ? 'w' : '-';
            $info .= ($perm & 0x0001)
                   ? (($perm & 0x0200) ? 't' : 'x')
                   : (($perm & 0x0200) ? 'T' : '-');
            return $info;
        }
    }

    /**
     * t@C݂邩`FbN
     *
     * @static
     * @access public 
     * @param string t@C
     * @return bool true: ݂Afalse: ݂Ȃ
     */
    function exists($file)
    {
        if (!file_exists($file)) {
            return false;
        }
        if (is_dir($file)) {
           return SyL_FilesystemDirectory::exists($file);
        } else {
           return SyL_FilesystemFile::exists($file);
        }
    }

    /**
     * t@C폜
     *
     * @static
     * @access public 
     * @param string t@C
     * @return bool true: 폜OKAfalse: 폜G[
     */
    function remove($file)
    {
        if (!file_exists($file)) {
            return false;
        }

        if (is_dir($file)) {
           return SyL_FilesystemDirectory::remove($file);
        } else {
           return SyL_FilesystemFile::remove($file);
        }
    }

    /**
     * fBNg쐬
     *
     * @static
     * @access public
     * @param string fBNgi΃pXj
     * @param int [h
     */
    function createDirectory($dir, $mode=0777)
    {
        SyL_FilesystemDirectory::createDirectory($dir, $mode=0777);
    }

    /**
     * t@CRs[
     *
     * @static
     * @access public
     * @param string t@C
     * @param string Vt@C
     * @return bool true: ύXOKAfalse: ύXG[
     */
    function copy($current_file, $new_file)
    {
        return copy($current_file, $new_file);
    }

    /**
     * vfύX
     *
     * @static
     * @access public
     * @param string t@C
     * @param string Vt@C
     * @return bool true: ύXOKAfalse: ύXG[
     */
    function rename($current_file, $new_file)
    {
        return rename($current_file, $new_file);
    }

    /**
     * p[~bVύX
     *
     * @static
     * @access public
     * @param int p[~bVi8i : 0755j
     * @return bool true: ύXAfalse: G[
     */
    function changePermission($file, $perm)
    {
        return chmod($file, $perm);
    }

    /**
     * fBNgt@C擾
     *
     * @static
     * @access public
     * @param string fBNg
     * @param bool true: fBNg擾Afalse: fBNg擾Ȃ
     * @param bool true: t@C擾Afalse: t@C擾Ȃ
     * @param int sőKw
     * @return array fBNgt@C
     */
    function getFiles($file, $is_get_dir=true, $is_get_file=true, $limit_depth=1)
    {
        return SyL_FilesystemDirectory::getFiles($file, $is_get_dir, $is_get_file, $limit_depth);
    }

    /**
     * t@C
     *
     * @static
     * @access public
     * @param string fBNg
     * @param string t@C
     * @param bool true: fBNg擾Afalse: fBNg擾Ȃ
     * @param bool true: t@C擾Afalse: t@C擾Ȃ
     * @param int sőKw
     * @return array fBNgt@C
     */
    function searchFiles($file, $word, $is_get_dir=true, $is_get_file=true, $limit_depth=1)
    {
        return SyL_FilesystemDirectory::searchFiles($file, $word, $is_get_dir, $is_get_file, $limit_depth);
    }

    /**
     * TCYifBNg̑St@CTCYj擾
     *
     * @static
     * @access public
     * @param string fBNg
     * @param bool true: fBNg̃TCY܂ށAfase: fBNg̃TCY܂܂Ȃ
     * @return int TCY
     */
    function getTotalSize($file, $is_dir_size=false)
    {
        if (!file_exists($file)) {
            return 0;
        }
        if (is_dir($file)) {
           return SyL_FilesystemDirectory::getTotalSize($file, $is_dir_size);
        } else {
           return filesize($file);
        }
    }

    /**
     * wfBNgȋ݂p[e[Vjɑ΂gp\eʂ擾
     *
     * @static
     * @access public
     * @param string fBNg
     * @return int gp\e
     */
    function getFreeSpace($dir)
    {
        return disk_free_space($dir);
    }

    /**
     * wfBNgȋ݂p[e[Vjɑ΂gpςݗeʂ擾
     *
     * @static
     * @access public
     * @param string fBNg
     * @return int gpςݗe
     */
    function getUsedSpace($dir)
    {
        $class = __CLASS__;
        $free  = call_user_func(array($class, 'getFreeSpace'),  $dir);
        $total = call_user_func(array($class, 'getTotalSpace'), $dir);
        return ($total - $free);
    }

    /**
     * wfBNgȋ݂p[e[Vjɑ΂鑍eʂ擾
     *
     * @static
     * @access public
     * @param string fBNg
     * @return int gpςݗe
     */
    function getTotalSpace($dir)
    {
        return disk_total_space($dir);
    }

    /**
     * eʕ\𐮌`
     *
     * @static
     * @access public
     * @param int e
     * @param int ̌
     * @return string `e
     */
    function formatSize($size, $suffix='KB', $number=0)
    {
        switch (strtoupper($suffix)) {
        case 'TB': $size /= 1099511627776; break;
        case 'GB': $size /= 1073741824; break;
        case 'MB': $size /= 1048576; break;
        case 'KB': $size /= 1024; break;
        }
        $size = number_format(round($size, $number), $number);
        $sizes = explode('.', $size, 2);
        if (isset($sizes[1])) {
            for ($i=$number-1; $i>=0; $i--) {
                $tmp = substr($sizes[1], $i, 1);
                if (!$tmp) {
                    $sizes[1] = substr($sizes[1], 0, $i);
                }
            }
            $size = $sizes[1] ? "{$sizes[0]}.{$sizes[1]}" : $sizes[0];
        }
        return $size;
    }

    /**
     * eʕ\₷悤ɐ`
     *
     * @static
     * @access public
     * @param int e
     * @param int ̌
     * @return string `e
     */
    function formatVisualSize($size, $number=0)
    {
        $suffix = 'B';
        if ($size > 1099511627776) {
            $size /= 1099511627776;
            $suffix = 'TB';
        } else if ($size > 1073741824) {
            $size /= 1073741824;
            $suffix = 'GB';
        } else if ($size > 1048576) {
            $size /= 1048576;
            $suffix = 'MB';
        } else if ($size > 1024) {
            $size /= 1024;
            $suffix = 'KB';
        }

        $size = number_format(round($size, $number), $number);
        $sizes = explode('.', $size, 2);
        if (isset($sizes[1])) {
            for ($i=$number-1; $i>=0; $i--) {
                $tmp = substr($sizes[1], $i, 1);
                if (!$tmp) {
                    $sizes[1] = substr($sizes[1], 0, $i);
                }
            }
            $size = $sizes[1] ? "{$sizes[0]}.{$sizes[1]}" : $sizes[0];
        }
        return $size . $suffix;
    } 
}

?>
