<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2008 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_MailSendSendmail.php,v 1.2 2008/09/23 09:06:16 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * Sendmail᡼饹
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_MailSendSendmail.php,v 1.2 2008/09/23 09:06:16 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_MailSendSendmail extends SyL_MailSend
{
    /**
     * Sendmailѥ
     *
     * @access private
     * @var string
     */
    var $sendmail_path = '/usr/lib/sendmail';

    /**
     * Sendmailޥɥѥ򥻥å
     * 
     * @access public
     * @param string Sendmailޥɥѥ
     */
    function setPath($sendmail_path)
    {
        $this->sendmail_path = $sendmail_path;
    }

    /**
     * ᡼¹
     *
     * @access public
     * @param object ᡼å֥
     * @return OK: true, NG: false
     */
    function send($message)
    {
        $from = $message->getFrom();
        $to   = $message->getTo();

        $additional_parameters = null;
        if (count($from) > 0) {
            // ꥿ѥΥå
            $additional_parameters = ' -f ' . $from[0];
        } else {
            $this->error_message = "[SyL error] From Address not found";
            return false;
        }
        if (count($to) == 0) {
            $this->error_message = "[SyL error] To Address not found";
            return false;
        }

        // ᡼¹
        $pmail = popen($this->sendmail_path . ' -t -i' . $additional_parameters, 'w');
        if (!$pmail) {
            $this->error_message = "[SyL error] Sendmail command execute error ({$this->sendmail_path})";
            return false;
        }
        fputs($pmail, $message->getMessage());
        pclose($pmail);

        return true;
    }
}

?>
