<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2008 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_MailReceivePop3.php,v 1.1 2008/01/20 15:09:34 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * å³饹
 */
require_once dirname(__FILE__) . '/../../SyL_Socket.php';

/**
 * SMTP᡼饹
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_MailReceivePop3.php,v 1.1 2008/01/20 15:09:34 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_MailReceivePop3 extends SyL_MailReceive
{
    /**
     * åȥ饹
     *
     * @access private
     * @var object
     */
    var $socket = null;
    /**
     * APOPȽ
     *
     * @access private
     * @var bool
     */
    var $apop = false;
    /**
     * ᡼ܥå᡼
     *
     * @access private
     * @var int
     */
    var $total_nums = 0;
    /**
     * ᡼ܥåХȿ
     *
     * @access private
     * @var int
     */
    var $total_bytes = 0;
    /**
     * SMTPޥɥ
     *
     * @access private
     * @var string
     */
    var $command_log = '';

    /**
     * ᡼
     *
     * @access public
     * @return int ᡼
     */
    function getTotalNums()
    {
        return $this->total_nums;
    }

    /**
     * ᡼Хȿ
     *
     * @access public
     * @return int ᡼Хȿ
     */
    function getTotalBytes()
    {
        return $this->total_bytes;
    }

    /**
     * APOPͭˤ
     *
     * @access public
     * @param bool APOPȽ
     */
    function enableApop($apop=true)
    {
        $this->apop = (bool)$apop;
    }

    /**
     * ᡼륵С³
     *
     * @access public
     * @return OK: true, NG: false
     */
    function connect()
    {
        if (is_object($this->socket)) {
            $this->quit();
        }

        if ($this->user == '') {
            $this->error_message = "[SyL error] User name not found";
            return false;
        }

        // åȥ֥Ⱥ
        $this->socket = new SyL_Socket($this->host, $this->port);
        $this->socket->setCommandCallBackFunc(array(&$this, 'receiveMessage'));

        // ǰΤ
        register_shutdown_function(array(&$this, 'quit'));

        if (!$this->socket->open()) {
            $this->error_message = $this->socket->getLastError();
            return false;
        } else {
            // APOPȽ
            if ($this->apop) {
                // ³å
                if (preg_match('/\+OK .*(<[^>]+>)/', $this->socket->receive(), $matches)) {
                    // 
                    $this->socket->send('APOP ' . $this->user . ' ' . md5($matches[1] . $this->passwd));
                    // å
                    $this->socket->receive();
                } else {
                    $this->error_message = "[SyL error] APOP Challenge not found";
                    return false;
                }
            } else {
                // ³å
                $this->socket->receive();
                // 桼̾
                $this->socket->send('USER ' . $this->user);
                // å
                $this->socket->receive();
                if (!$this->isError()) {
                    // ѥ
                    $this->socket->send('PASS ' . $this->passwd);
                    // å
                    $this->socket->receive();
                    // ᡼
                    if (!$this->isError()) {
                        $this->stat();
                    }
                }
            }
        }

        return !$this->isError();
    }

    /**
     * ᡼Хȿ
     *
     * @access public
     */
    function stat()
    {
        $this->socket->send('STAT');
        $stat = trim($this->socket->receive());
        if (preg_match('/^\+OK/', $stat)) {
            $stats = explode(' ', $stat);
            $this->total_nums  = $stats[1];
            $this->total_bytes = $stats[2];
        }
    }

    /**
     * ƥ᡼뤴ȤΥХȿ
     *
     * @access public
     * @return array ƥ᡼뤴ȤΥХȿ
     */
    function getList()
    {
        $list = array();
        $this->socket->send('LIST');
        if (preg_match('/^\+OK/', $this->socket->receive())) {
            while (true) {
                $receive = trim($this->socket->receive());
                if (!$receive || ($receive == '.')) {
                    break;
                }
                list($num, $bytes) = explode(' ', $receive, 2);
                $list[$num] = $bytes;
            }
        }
        return $list;
    }

    /**
     * ᡼¹
     *
     * @access public
     * @param int ᡼åֹ
     * @return object ᡼å֥
     */
    function receive($num)
    {
        if (!is_numeric($num) || ($num <= 0)) {
            $this->error_message = "[SyL error] Invalid mail message num ($num)";
            return false;
        }

        $data = '';
        $this->socket->send('RETR ' . $num);
        if (preg_match('/^\+OK/', $this->socket->receive())) {
            while (true) {
                $receive = $this->socket->receive();
                if (!$receive || (trim($receive) == '.')) {
                    break;
                }
                $data .= $receive;
            }
        } else {
            return false;
        }

        $message =& $this->createMessage();
        $message->setMessage($data);

        return $message;
    }

    /**
     * ᡼¹
     *
     * @access public
     * @param int ᡼åֹ
     * @return bool true: false: 顼
     */
    function delete($num)
    {
        if (!is_numeric($num) || ($num <= 0)) {
            $this->error_message = "[SyL error] Invalid mail message num ($num)";
            return false;
        }
        $this->socket->send('DELE ' . $num);
        $this->socket->receive();
        return !$this->isError();
    }

    /**
     * ᡼륵СȤ³Ĥ
     *
     * @access public
     */
    function quit()
    {
        if (is_object($this->socket)) {
            // λå
            $this->socket->send('QUIT');
            // λå
            $this->socket->receive();
            // åȤĤ
            $this->socket->close();
        }
        $this->socket = null;
    }

    /**
     * SMTPޥɼå
     *
     * @access private
     * @param string send or receive
     * @param string ޥɥå
     */
    function receiveMessage($type, $message)
    {
        $message = trim($message);
        $this->command_log .= "[{$type}] {$message}\n";
        if ($type == 'receive') {
            if (preg_match('/^\-ERR/', $message)) {
                $this->error_message = "[SyL error] POP3 command error ($message)";
            }
        }
    }

    /**
     * åȥޥɼ
     *
     * @access public
     * @return string åȥޥɼ
     */
    function getCommandLog()
    {
        return $this->command_log;
    }
}

?>
