<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2008 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_XmlRssClientResponse.php,v 1.1 2008/02/02 14:40:44 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * HTTPꥯȷ̥饹
 */
require_once dirname(__FILE__) . '/../../Http/SyL_HttpClientResponse.php';
/**
 * RSS꡼饹
 */
require_once 'SyL_XmlRssReader.php';

/**
 * RSSꥯȥ쥹ݥ󥹥饹
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_XmlRssClientResponse.php,v 1.1 2008/02/02 14:40:44 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_XmlRssClientResponse extends SyL_HttpClientResponse
{
    /**
     * RSS ꡼֥
     *
     * @access private
     * @var object
     */
    var $reader = null;

    /**
     * 󥹥ȥ饯
     * 
     * @access public
     * @param string ꥯȷ
     * @param string 饤ȥ󥳡
     * @param string RSSС
     */
    function SyL_XmlRssClientResponse($data, $client_encode='', $rss_version='')
    {
        parent::SyL_HttpClientResponse($data, $client_encode);
        $this->reader =& SyL_XmlRssReader::factory($this->body, $rss_version);
        if ($this->client_encode) {
            $this->reader->setClientEncode($this->client_encode);
        }
        $this->reader->parseXml();
    }

    /**
     * ꤷͥ
     *
     * @access public
     * @return mixed ꤷͥ
     */
    function getChannel($name)
    {
        return $this->reader->getChannel($name);
    }

    /**
     * ꤷͥ°
     *
     * @access public
     * @param string ̾
     * @param string ǥ̾
     * @return array ꤷͥ°
     */
    function getChannelAttr($name, $subname=null)
    {
        return $this->reader->getChannelAttr($name, $subname);
    }

    /**
     * ۿ
     *
     * @access public
     * @return array ۿ
     */
    function getItems()
    {
        return $this->reader->getItems();
    }

    /**
     * ۿ°
     *
     * @access public
     * @param int 
     * @param string ̾
     * @param string ǥ̾
     * @return array ۿ°
     */
    function getItemAttr($index, $name, $subname=null)
    {
        return $this->reader->getItemAttr($index, $name, $subname);
    }

    /**
     * ۿ
     *
     * @access public
     * @return int ۿ
     */
    function getItemCount()
    {
        return $this->reader->getItemCount();
    }
}

?>
