<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2008 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_WebServiceNewsTopicsResponse.php,v 1.2 2008/09/11 13:06:59 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * WEBӥ쥹ݥ󥹥饹Yahoo! Japan - ˥塼 - ȥԥåAPI
 *
 * ܺ٤ϡYahoo!ǥ٥åѡͥåȥ
 *   http://developer.yahoo.co.jp/
 * ˥塼 - ȥԥåAPI
 *   http://developer.yahoo.co.jp/news/topics/V1/topics.html
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_WebServiceNewsTopicsResponse.php,v 1.2 2008/09/11 13:06:59 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_WebServiceNewsTopicsResponse extends SyL_WebServiceYahoo_co_jpResponse
{
    /**
     * ˰פ
     *
     * @access private
     * @var int 
     */
     var $total_results_returned = 0;
    /**
     * ̥ǡ
     *
     * @access private
     * @var array
     */
    var $results = array();

    /**
     * XMLǡƼϥɥ᥽å
     *
     * @access protected
     * @param string XMLΥѥ
     * @param string XMLΥ°
     * @param string XMLΥ
     */
    function getElement($current_path, $attribute, $text)
    {
        static $i = -1;

        switch ($current_path) {
        // =============================
        // 
        // =============================
        case '/ResultSet':
            if (isset($attribute['totalResultsReturned'])) {
                $this->total_results_returned = $attribute['totalResultsReturned'];
            }
            break;
        case '/ResultSet/Result':
            $i++;
            break;
        // Ǹ˥ȥԥå򹹿
        case '/ResultSet/Result/datetime': $this->results[$i]['datetime'] = $text; break;
        // 15ʸ٤θФ
        case '/ResultSet/Result/title': $this->results[$i]['title'] = $text; break;
        // ȥԥå˴Ϣ륭
        case '/ResultSet/Result/keyword': $this->results[$i]['keyword'] = array(); break;
        case '/ResultSet/Result/keyword/word': $this->results[$i]['keyword'][] = $text; break;
        // ߥȥԥå̾
        case '/ResultSet/Result/topicname': $this->results[$i]['topicname'] = $text; break;
        // ƥ
        case '/ResultSet/Result/category': $this->results[$i]['category'] = $text; break;
        // ֥ƥ
        case '/ResultSet/Result/subcategory': $this->results[$i]['subcategory'] = $text; break;
        // url
        case '/ResultSet/Result/url': $this->results[$i]['url'] = $text; break;
        // Yahoo! JAPANȥåץڡؤηǺ̵ͭ
        case '/ResultSet/Result/topflg': $this->results[$i]['topflg'] = $text; break;
        // PVɸ
        case '/ResultSet/Result/pvindex': $this->results[$i]['pvindex'] = $text; break;
        // ȥԥå˴Ϣȥԥå
        case '/ResultSet/Result/relatedtopics': $this->results[$i]['relatedtopics'] = array(); break;
        // ȥԥå˴Ϣȥԥå - Ϣȥԥå̾
        case '/ResultSet/Result/relatedtopics/title': $this->results[$i]['relatedtopics']['title'][] = array(); break;
        // ȥԥå˴Ϣȥԥå - ϢȥԥåURL
        case '/ResultSet/Result/relatedtopics/url': $this->results[$i]['relatedtopics']['url'][] = array(); break;
        // ȥԥå˴Ϣ륵
        case '/ResultSet/Result/relatedsite': $this->results[$i]['relatedsite'] = array(); break;
        // ȥԥå˴Ϣ륵 - Ϣȥԥå̾
        case '/ResultSet/Result/relatedsite/title': $this->results[$i]['relatedsite']['title'][] = array(); break;
        // ȥԥå˴Ϣ륵 - ϢȥԥåURL
        case '/ResultSet/Result/relatedsite/url': $this->results[$i]['relatedsite']['url'][] = array(); break;

        // ¾
        default: parent::getElement($current_path, $attribute, $text); break;
        }
    }

    /**
     * 
     *
     * @access public
     * @return int 
     */
    function getTotalResultsReturned()
    {
        return $this->total_results_returned;
    }

    /**
     * ̥ǡ
     *
     * @access public
     * @return array ̥ǡ
     */
    function getResults()
    {
        return $this->results;
    }
}

?>
