<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2008 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_WebServiceMapLocalSearchResponse.php,v 1.2 2008/09/11 13:06:59 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * WEBӥ쥹ݥ󥹥饹Yahoo! Japan - Ͽ޾ - 륵API
 *
 * ܺ٤ϡYahoo!ǥ٥åѡͥåȥ
 *   http://developer.yahoo.co.jp/
 * Ͽ޾ - 륵API
 *   http://developer.yahoo.co.jp/map/localsearch/V1/localsearch.html
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_WebServiceMapLocalSearchResponse.php,v 1.2 2008/09/11 13:06:59 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_WebServiceMapLocalSearchResponse extends SyL_WebServiceYahoo_co_jpResponse
{
    /**
     * ׷
     *
     * @access private
     * @var int
     */
     var $count = 0;
    /**
     * Ϸ
     *
     * @access private
     * @var int
     */
     var $view_count = 0;
    /**
     * 
     *
     * @access private
     * @var string
     */
     var $query = null;
    /**
     * Ͽޤ˴ؤ
     *
     * @access private
     * @var array
     */
    var $items = array();

    /**
     * XMLǡƼϥɥ᥽å
     *
     * @access protected
     * @param string XMLΥѥ
     * @param string XMLΥ°
     * @param string XMLΥ
     */
    function getElement($current_path, $attribute, $text)
    {
        static $item_i = -1;

        switch ($current_path) {
        // =============================
        // 
        // =============================
        // ׷
        case '/LocalSearchResult/Count': $this->count = $text; break;
        // Ϸ
        case '/LocalSearchResult/ViewCount': $this->view_count = $text; break;
        // 
        case '/LocalSearchResult/Query': $this->query = $text; break;

        // Ͽޤ˴ؤ
        case '/LocalSearchResult/Item':  $item_i++; break;
        // ƥ
        case '/LocalSearchResult/Item/Category': $this->items[$item_i]['Category'] = $text; break;
        // ̾
        case '/LocalSearchResult/Item/Title': $this->items[$item_i]['Title'] = $text; break;
        // 
        case '/LocalSearchResult/Item/Address': $this->items[$item_i]['Address'] = $text; break;
        // ٥
        case '/LocalSearchResult/Item/AddressLevel': $this->items[$item_i]['AddressLevel'] = $text; break;
        // ¬Ϸϰٷ
        case '/LocalSearchResult/Item/DatumTky97': $this->items[$item_i]['DatumTky97'] = array(); break;
        // ¬Ϸϰٷ - ١10ʷ 
        case '/LocalSearchResult/Item/DatumTky97/Lat': $this->items[$item_i]['DatumTky97']['Lat'] = $text; break;
        // ¬Ϸϰٷ - ١10ʷ
        case '/LocalSearchResult/Item/DatumTky97/Lon': $this->items[$item_i]['DatumTky97']['Lon'] = $text; break;
        // ¬ϷϷٷ
        case '/LocalSearchResult/Item/DatumWgs84': $this->items[$item_i]['DatumWgs84'] = array(); break;
        // ¬ϷϷٷ - ١10ʷ 
        case '/LocalSearchResult/Item/DatumWgs84/Lat': $this->items[$item_i]['DatumWgs84']['Lat'] = $text; break;
        // ¬ϷϷٷ - ١10ʷ
        case '/LocalSearchResult/Item/DatumWgs84/Lon': $this->items[$item_i]['DatumWgs84']['Lon'] = $text; break;
        // ܺ٥ڡؤURL
        case '/LocalSearchResult/Item/Url': $this->items[$item_i]['Url'] = $text; break;

        // ¾
        default: parent::getElement($current_path, $attribute, $text); break;
        }
    }

    /**
     * ׷
     *
     * @access public
     * @return int ׷
     */
    function getCount()
    {
        return $this->count;
    }

    /**
     * Ϸ
     *
     * @access public
     * @return int Ϸ
     */
    function getViewCount()
    {
        return $this->view_count;
    }

    /**
     * ɤ
     *
     * @access public
     * @return string 
     */
    function getQuery()
    {
        return $this->query;
    }

    /**
     * Ͽޤ˴ؤ
     *
     * @access public
     * @return array Ͽޤ˴ؤ
     */
    function getItems()
    {
        return $this->items;
    }
}

?>
