<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2008 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_WebServiceChiebukuroQuestionSearchRequest.php,v 1.3 2008/09/11 13:06:59 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * WEBӥ쥹ݥ󥹥饹Yahoo! Japan - Yahoo!η:両ѡ
 */
require_once 'SyL_WebServiceChiebukuroQuestionSearchResponse.php';

/**
 * WEBӥꥯȥ饹Yahoo! Japan - Yahoo!η:両ѡ
 *
 * ܺ٤ϡYahoo!ǥ٥åѡͥåȥ
 *   http://developer.yahoo.co.jp/
 * ָ
 *   http://developer.yahoo.co.jp/chiebukuro/questionSearch/V1/questionSearch.html
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_WebServiceChiebukuroQuestionSearchRequest.php,v 1.3 2008/09/11 13:06:59 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_WebServiceChiebukuroQuestionSearchRequest extends SyL_WebServiceYahoo_co_jpRequest
{
    /**
     * WEBӥСΥۥ̾
     *
     * @access protected
     * @var string
     */
    var $host = 'chiebukuro.yahooapis.jp';
    /**
     * ¹URLѥ
     *
     * @access protected
     * @var string
     */
    var $path = '/Chiebukuro/V1/questionSearch';
    /**
     * 쥹ݥ󥹥饹̾
     *
     * @access protected
     * @var string
     */
    var $response_class = 'SyL_WebServiceChiebukuroQuestionSearchResponse';

    /**
     * ꡼򥻥åȤ
     *
     * @access public
     * @param string ꡼
     */
    function setQuery($query)
    {
        parent::set('query', $query);
    }

    /**
     * 긡μ򥻥åȤ
     * (all, any, phrase)
     *
     * @access public
     * @param string 긡μ
     */
    function setType($type)
    {
        switch ($type) {
        case 'all':
        case 'any':
        case 'phrase':
            parent::set('type', $type);
            break;
        default:
            trigger_error("[SyL error] Invalid `type' property ({$type}) in `" . __CLASS__ . "' class", E_USER_ERROR);
        }
    }

    /**
     * ƥID򥻥åȤ
     *
     * @access public
     * @param int ƥID
     */
    function setCategoryid($categoryid)
    {
        if (preg_match('/^\d+$/', $categoryid)) {
            parent::set('categoryid', $categoryid);
        } else {
            trigger_error("[SyL error] Invalid `categoryid' property ({$categoryid}) in `" . __CLASS__ . "' class", E_USER_ERROR);
        }
    }

    /**
     * ξ֤򥻥åȤ
     * (all, open, vote, solved)
     *
     * @access public
     * @param string ξ
     */
    function setCondition($condition)
    {
        switch ($condition) {
        case 'all':
        case 'open':
        case 'vote':
        case 'solved':
            parent::set('condition', $condition);
            break;
        default:
            trigger_error("[SyL error] Invalid `condition' property ({$condition}) in `" . __CLASS__ . "' class", E_USER_ERROR);
        }
    }

    /**
     * ֵѷ̤Υȹܤ򥻥åȤ
     *
     * @access public
     * @param string ֵѷ̤Υȹ
     */
    function setSort($sort)
    {
        switch ($sort) {
        case '-posteddate':
        case '+posteddate':
        case '&#8211;anscount':
        case '+anscount':
            parent::set('sort', $sort);
            break;
        default:
            trigger_error("[SyL error] Invalid `sort' property ({$sort}) in `" . __CLASS__ . "' class", E_USER_ERROR);
        }
    }

    /**
     * ֵѷ̤Ƭ֤򥻥åȤ
     *
     * @access public
     * @param int ֵѷ̤Ƭ
     */
    function setStart($start)
    {
        if (preg_match('/^\d+$/', $start)) {
            $results = isset($this->parameters['results']) ? $this->parameters['results'] : 10;
            if (($start + $results - 1) <= 1000) {
                parent::set('start', $start);
            } else {
                trigger_error("[SyL error] Invalid `start' property ({$start}) in `" . __CLASS__ . "' class", E_USER_ERROR);
            }
        } else {
            trigger_error("[SyL error] Invalid `start' property ({$start}) in `" . __CLASS__ . "' class", E_USER_ERROR);
        }
    }

    /**
     * ֵѷ̤ο򥻥åȤ
     *
     * @access public
     * @param int ֵѷ̤ο
     */
    function setResults($results)
    {
        if (preg_match('/^\d+$/', $results) && (($results >= 0) && ($results <= 100))) {
            parent::set('results', $results);
        } else {
            trigger_error("[SyL error] Invalid `results' property ({$results}) in `" . __CLASS__ . "' class", E_USER_ERROR);
        }
    }
}

?>
