<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2008 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_WebServiceCategoryBrowseResponse.php,v 1.1 2008/09/11 13:06:59 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * WEBӥ쥹ݥ󥹥饹Yahoo! Japan - ǥ쥯ȥĥ꡼ѡ
 *
 * ܺ٤ϡYahoo!ǥ٥åѡͥåȥ
 *   http://developer.yahoo.co.jp/
 * ǥ쥯ȥĥ꡼
 *   http://developer.yahoo.co.jp/category/browse/V1/browse.html
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_WebServiceCategoryBrowseResponse.php,v 1.1 2008/09/11 13:06:59 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_WebServiceCategoryBrowseResponse extends SyL_WebServiceYahoo_co_jpResponse
{
    /**
     * 쥹ݥ󥹤ξ֤䥵СΥå
     *
     * @access private
     * @var array
     */
     var $status = array();
    /**
     * ƥ˴ؤ
     *
     * @access private
     * @var array
     */
    var $space = array();
    /**
     * ƥItemη
     *
     * @access private
     * @var int
     */
    var $category_count = 0;
    /**
     * ƥ꤫󥯤Ƥ벼̥ƥȥ硼ȥåȥƥν
     *
     * @access private
     * @var array
     */
    var $category = array();
    /**
     * Ͽ줿Itemη
     *
     * @access private
     * @var int
     */
    var $site_count = 0;
    /**
     * Yahoo!ƥϿ줿
     *
     * @access private
     * @var array
     */
    var $site = array();

    /**
     * XMLǡƼϥɥ᥽å
     *
     * @access protected
     * @param string XMLΥѥ
     * @param string XMLΥ°
     * @param string XMLΥ
     */
    function getElement($current_path, $attribute, $text)
    {
        static $item_i = -1;
        static $site_i = -1;

        switch ($current_path) {
        // APIϤ줿ѥ᡼ν
        case '/CategoryResult/Status/Args/Arg': $this->status[$attribute['Name']] = $attribute['Value']; break;

        // =============================
        // 顼
        // =============================
        // 顼Ƚ
        case '/CategoryResult/Status/Errors': $this->error = true; break;
        case '/CategoryResult/Status/Errors/Error': $this->error_message .= $text; break;

        // =============================
        // 
        // =============================
        // ƥID
        case '/CategoryResult/Space/Id': $this->space['Id'] = $text; break;
        // ƥƥID
        case '/CategoryResult/Space/Parent': $this->space['Parent'] = $text; break;
        // Ǿ̥ƥ꤫Ρƥγؤο
        case '/CategoryResult/Space/Depth': $this->space['Depth'] = $text; break;
        // ƥ̾
        case '/CategoryResult/Space/Title': $this->space['Title'] = $text; break;
        // ƥ̾ɤ
        case '/CategoryResult/Space/JTitle': $this->space['JTitle'] = $text; break;
        // Yahoo! JAPAN󶡤Yahoo!ƥΥڡURL顢http://dir.yahoo.co.jpפ
        case '/CategoryResult/Space/Path': $this->space['Path'] = $text; break;
        // Yahoo! JAPAN󶡤Yahoo!ƥΡڡΡ֥ƥѥBreadcrumbˡפ˻ѤƤʸ
        case '/CategoryResult/Space/JPath': $this->space['JPath'] = $text; break;
        // IDȤäƥ곬
        case '/CategoryResult/Space/Spath': $this->space['Spath'] = $text; break;
        // ȤϿ줿դ⤷ϡƥ꤬줿
        case '/CategoryResult/Space/Created': $this->space['Created'] = $text; break;

        // ƥItemη
        case '/CategoryResult/Category/Count': $this->category_count = $text; break;
        // Itemη
        case '/CategoryResult/Sites/Count': $this->site_count = $text; break;
        // ƥItem
        case '/CategoryResult/Category/Item': $item_i++; break;
        // Item
        case '/CategoryResult/Sites/Item': $site_i++; break;

        // ƥ꥿
        case '/CategoryResult/Category/Item/Type': $this->category[$item_i]['Type'] = $text; break;
        case '/CategoryResult/Sites/Item/Type': $this->site[$site_i]['Type'] = $text; break;
        // ƥID
        case '/CategoryResult/Category/Item/Id': $this->category[$item_i]['Id'] = $text; break;
        case '/CategoryResult/Sites/Item/Id': $this->site[$site_i]['Id'] = $text; break;
        // 硼ȥåȥƥ꼫ΤID
        case '/CategoryResult/Category/Item/Link': $this->category[$item_i]['Link'] = $text; break;
        case '/CategoryResult/Sites/Item/Link': $this->site[$site_i]['Link'] = $text; break;
        // Yahoo! JAPAN󶡤Yahoo!ƥΥڡURL顢http://dir.yahoo.co.jpפ
        case '/CategoryResult/Category/Item/Path': $this->category[$item_i]['Path'] = $text; break;
        case '/CategoryResult/Sites/Item/Path': $this->site[$site_i]['Path'] = $text; break;
        // ƥ̾
        case '/CategoryResult/Category/Item/Title': $this->category[$item_i]['Title'] = $text; break;
        case '/CategoryResult/Sites/Item/Title': $this->site[$site_i]['Title'] = $text; break;
        // ƥ̾ɤ
        case '/CategoryResult/Category/Item/JTitle': $this->category[$item_i]['JTitle'] = $text; break;
        case '/CategoryResult/Sites/Item/JTitle': $this->site[$site_i]['JTitle'] = $text; break;
        // ϿȤURL
        case '/CategoryResult/Category/Item/Url': $this->category[$item_i]['Url'] = $text; break;
        case '/CategoryResult/Sites/Item/Url': $this->site[$site_i]['Url'] = $text; break;
        // ϿȤؤΥѡʥåѡURL
        case '/CategoryResult/Category/Item/ClickUrl': $this->category[$item_i]['ClickUrl'] = $text; break;
        case '/CategoryResult/Sites/Item/ClickUrl': $this->site[$site_i]['ClickUrl'] = $text; break;
        // ϿȤ
        case '/CategoryResult/Category/Item/Summary': $this->category[$item_i]['Summary'] = $text; break;
        case '/CategoryResult/Sites/Item/Summary': $this->site[$site_i]['Summary'] = $text; break;
        // ȤϿ줿դ⤷ϡƥ꤬줿
        case '/CategoryResult/Category/Item/Created': $this->category[$item_i]['Created'] = $text; break;
        case '/CategoryResult/Sites/Item/Created': $this->site[$site_i]['Created'] = $text; break;
        // 1ְ˿Ͽ줿Ȥξ1סʳξ0
        case '/CategoryResult/Category/Item/New': $this->category[$item_i]['New'] = $text; break;
        case '/CategoryResult/Sites/Item/New': $this->site[$site_i]['New'] = $text; break;
        // Yahoo!ƥȼδˤäơͥ줿ƤǤɾ줿Ȥξ1סʳξϡ0
        case '/CategoryResult/Category/Item/Cool': $this->category[$item_i]['Cool'] = $text; break;
        case '/CategoryResult/Sites/Item/Cool': $this->site[$site_i]['Cool'] = $text; break;

        // ¾
        default: parent::getElement($current_path, $attribute, $text); break;
        }
    }

    /**
     * 쥹ݥ󥹤ξ֤䥵СΥå
     *
     * @access public
     * @param string 
     * @return mixed 쥹ݥ󥹤ξ֤䥵СΥå
     */
    function getStatus($name=null)
    {
        if ($name !== null) {
            return isset($this->status[$name]) ? $this->status[$name] : null;
        } else {
            return $this->status;
        }
    }

    /**
     * ƥ˴ؤ
     *
     * @access public
     * @param string 
     * @return mixed ƥ˴ؤ
     */
    function getSpace($name=null)
    {
        if ($name !== null) {
            return isset($this->space[$name]) ? $this->space[$name] : null;
        } else {
            return $this->space;
        }
    }

    /**
     * ƥ
     *
     * @access public
     * @return int ƥ
     */
    function getCategoryCount()
    {
        return $this->category_count;
    }

    /**
     * ƥǡ
     *
     * @access public
     * @return array ƥǡ
     */
    function getCategory()
    {
        return $this->category;
    }

    /**
     * ȿ
     *
     * @access public
     * @return int ȿ
     */
    function getSiteCount()
    {
        return $this->site_count;
    }

    /**
     * ȥǡ
     *
     * @access public
     * @return array ȥǡ
     */
    function getSite()
    {
        return $this->site;
    }
}

?>
