<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2008 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_WebServiceCategoryBrowseRequest.php,v 1.1 2008/09/11 13:06:59 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * WEBӥ쥹ݥ󥹥饹Yahoo! Japan - ǥ쥯ȥĥ꡼ѡ
 */
require_once 'SyL_WebServiceCategoryBrowseResponse.php';

/**
 * WEBӥꥯȥ饹Yahoo! Japan - ǥ쥯ȥĥ꡼ѡ
 *
 * ܺ٤ϡYahoo!ǥ٥åѡͥåȥ
 *   http://developer.yahoo.co.jp/
 * ǥ쥯ȥĥ꡼
 *   http://developer.yahoo.co.jp/category/browse/V1/browse.html
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_WebServiceCategoryBrowseRequest.php,v 1.1 2008/09/11 13:06:59 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_WebServiceCategoryBrowseRequest extends SyL_WebServiceYahoo_co_jpRequest
{
    /**
     * WEBӥСΥۥ̾
     *
     * @access protected
     * @var string
     */
    var $host = 'dir.yahooapis.jp';
    /**
     * ¹URLѥ
     *
     * @access protected
     * @var string
     */
    var $path = '/Category/V1/Category';
    /**
     * 쥹ݥ󥹥饹̾
     *
     * @access protected
     * @var string
     */
    var $response_class = 'SyL_WebServiceCategoryBrowseResponse';

    /**
     * ƥڡid򥻥åȤ
     *
     * @access public
     * @param int ƥڡid
     */
    function setId($id)
    {
        if (preg_match('/^\d+$/', $id)) {
            parent::set('id', $id);
        } else {
            trigger_error("[SyL error] Invalid `id' property ({$id}) in `" . __CLASS__ . "' class", E_USER_ERROR);
        }
    }

    /**
     * ƥڡURLhttp://dir.yahoo.co.jpפʬ򥻥åȤ
     *
     * @access public
     * @param string ƥڡURLhttp://dir.yahoo.co.jpפʬ
     */
    function setPath($path)
    {
        parent::set('path', $path);
    }

    /**
     * ƥʬ򥻥åȤ
     *
     * @access public
     * @param int ƥʬ
     */
    function setType($type)
    {
        switch ((string)$type) {
        case '0': // ƥǡȥȥǡ
        case '1': // ƥǡΤߡ
        case '2': // ȥǡΤߡ
            parent::set('type', $type);
            break;
        default:
            trigger_error("[SyL error] Invalid `type' property ($type) in `" . __CLASS__ . "' class", E_USER_ERROR);
        }
    }

    /**
     * ץѥȤ̵ͭ򥻥åȤ
     *
     * @access public
     * @param int ץѥȤ̵ͭ
     */
    function setExpand($expand)
    {
        $expand = ($expand) ? '1' : '0';
        parent::set('expand', $expand);
    }
}

?>
