<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2008 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_WebServiceAuctionCategoryLeafRequest.php,v 1.3 2008/09/11 13:06:59 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * WEBӥ쥹ݥ󥹥饹Yahoo! Japan -  - ʥꥹѡ
 */
require_once 'SyL_WebServiceAuctionCategoryLeafResponse.php';

/**
 * WEBӥꥯȥ饹Yahoo! Japan -  - ʥꥹѡ
 *
 * ܺ٤ϡYahoo!ǥ٥åѡͥåȥ
 *   http://developer.yahoo.co.jp/
 *  - ʥꥹ
 *   http://developer.yahoo.co.jp/auctions/rest/categoryleaf/V1/categoryleaf.html
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_WebServiceAuctionCategoryLeafRequest.php,v 1.3 2008/09/11 13:06:59 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_WebServiceAuctionCategoryLeafRequest extends SyL_WebServiceYahoo_co_jpRequest
{
    /**
     * WEBӥСΥۥ̾
     *
     * @access protected
     * @var string
     */
    var $host = 'auctions.yahooapis.jp';
    /**
     * ¹URLѥ
     *
     * @access protected
     * @var string
     */
    var $path = '/AuctionWebService/V1/CategoryLeaf';
    /**
     * 쥹ݥ󥹥饹̾
     *
     * @access protected
     * @var string
     */
    var $response_class = 'SyL_WebServiceAuctionCategoryLeafResponse';

    /**
     * ƥID򥻥åȤ
     *
     * @access public
     * @param int ƥID
     */
    function setCategory($categoy)
    {
        if (preg_match('/^\d+$/', $categoy)) {
            parent::set('category', $categoy);
        } else {
            trigger_error("[SyL error] Invalid `categoy' property ({$categoy}) in `" . __CLASS__ . "' class", E_USER_ERROR);
        }
    }

    /**
     * ʥꥹȤΥڡֹ򥻥åȤ
     *
     * @access public
     * @param int ʥꥹȤΥڡֹ
     */
    function setPage($page)
    {
        if (preg_match('/^\d+$/', $page) && ($page > 0)) {
            parent::set('page', $page);
        } else {
            trigger_error("[SyL error] Invalid `page' property ({$page}) in `" . __CLASS__ . "' class", E_USER_ERROR);
        }
    }

    /**
     * ʤνʶʬ򥻥åȤ
     *
     * @access public
     * @param int ʤνʶʬ
     */
    function setStore($store)
    {
        switch ((string)$store) {
        case '0': // ٤Ƥξ
        case '1': // 󥹥ȥν
        case '2': // ̤νʼԤν
            parent::set('store', $store);
            break;
        default:
            trigger_error("[SyL error] Invalid `store' property ($store) in `" . __CLASS__ . "' class", E_USER_ERROR);
        }
    }

    /**
     * ѥӥѲǽʾʤιʤ߻򥻥åȤ
     *
     * @access public
     * @param int ѥӥѲǽʾʤιʤ߻
     */
    function setEscrow($escrow)
    {
        if (preg_match('/^\d+$/', $escrow)) {
            parent::set('escrow', $escrow);
        } else {
            trigger_error("[SyL error] Invalid `escrow' property ({$escrow}) in `" . __CLASS__ . "' class", E_USER_ERROR);
        }
    }

    /**
     * Yahoo!󤿤ѤѤǽʾʤιʤ߻򥻥åȤ
     *
     * @access public
     * @param int Yahoo!󤿤ѤѤǽʾʤιʤ߻
     */
    function setEasypayment($easypayment)
    {
        if (preg_match('/^\d+$/', $easypayment)) {
            parent::set('easypayment', $easypayment);
        } else {
            trigger_error("[SyL error] Invalid `easypayment' property ({$easypayment}) in `" . __CLASS__ . "' class", E_USER_ERROR);
        }
    }

    /**
     * newΤĤʤιʤ߻򥻥åȤ
     *
     * @access public
     * @param int newΤĤʤιʤ߻
     */
    function setNew($new)
    {
        if (preg_match('/^\d+$/', $new)) {
            parent::set('new', $new);
        } else {
            trigger_error("[SyL error] Invalid `new' property ({$new}) in `" . __CLASS__ . "' class", E_USER_ERROR);
        }
    }

    /**
     * դξʤιʤ߻򥻥åȤ
     *
     * @access public
     * @param int դξʤιʤ߻
     */
    function setLargeimg($largeimg)
    {
        if (preg_match('/^\d+$/', $largeimg)) {
            parent::set('largeimg', $largeimg);
        } else {
            trigger_error("[SyL error] Invalid `largeimg' property ({$largeimg}) in `" . __CLASS__ . "' class", E_USER_ERROR);
        }
    }

    /**
     * ̵ξʤιʤ߻򥻥åȤ
     *
     * @access public
     * @param int ̵ξʤιʤ߻
     */
    function setFreeshipping($freeshipping)
    {
        if (preg_match('/^\d+$/', $freeshipping)) {
            parent::set('freeshipping', $freeshipping);
        } else {
            trigger_error("[SyL error] Invalid `freeshipping' property ({$freeshipping}) in `" . __CLASS__ . "' class", E_USER_ERROR);
        }
    }

    /**
     * £ʸʤιʤ߻򥻥åȤ
     *
     * @access public
     * @param int £ʸʤιʤ߻
     */
    function setWrappingicon($wrappingicon)
    {
        if (preg_match('/^\d+$/', $wrappingicon)) {
            parent::set('wrappingicon', $wrappingicon);
        } else {
            trigger_error("[SyL error] Invalid `wrappingicon' property ({$wrappingicon}) in `" . __CLASS__ . "' class", E_USER_ERROR);
        }
    }

    /**
     * ¨㾦ʤιʤ߻򥻥åȤ
     *
     * @access public
     * @param int ¨㾦ʤιʤ߻
     */
    function setBuynow($buynow)
    {
        if (preg_match('/^\d+$/', $buynow)) {
            parent::set('buynow', $buynow);
        } else {
            trigger_error("[SyL error] Invalid `buynow' property ({$buynow}) in `" . __CLASS__ . "' class", E_USER_ERROR);
        }
    }

    /**
     * ξʤιʤ߻򥻥åȤ
     *
     * @access public
     * @param int ξʤιʤ߻
     */
    function setThumbnail($thumbnail)
    {
        if (preg_match('/^\d+$/', $thumbnail)) {
            parent::set('thumbnail', $thumbnail);
        } else {
            trigger_error("[SyL error] Invalid `thumbnail' property ({$thumbnail}) in `" . __CLASS__ . "' class", E_USER_ERROR);
        }
    }

    /**
     * ܤΥξʤιʤ߻򥻥åȤ
     *
     * @access public
     * @param int ܤΥξʤιʤ߻
     */
    function setAttn($attn)
    {
        if (preg_match('/^\d+$/', $attn)) {
            parent::set('attn', $attn);
        } else {
            trigger_error("[SyL error] Invalid `attn' property ({$attn}) in `" . __CLASS__ . "' class", E_USER_ERROR);
        }
    }

    /**
     * ΩΤĤʤιʤ߻򥻥åȤ
     *
     * @access public
     * @param int ΩΤĤʤιʤ߻
     */
    function setGift_icon($gift_icon)
    {
        switch ((string)$gift_icon) {
        case '0': // ʤ
        case '1': // 
        case '2': // 
        case '3': // 
        case '4': // 
        case '5': // ݾڽ
        case '6': // å
        case '7': // Ź
        case '8': // ľ
            parent::set('gift_icon', $gift_icon);
            break;
        default:
            trigger_error("[SyL error] Invalid `gift_icon' property ({$gift_icon}) in `" . __CLASS__ . "' class", E_USER_ERROR);
        }
    }

    /**
     * ʥꥹȤΥȹܤλ򥻥åȤ
     *
     * @access public
     * @param string ʥꥹȤΥȹܤλ
     */
    function setSort($sort)
    {
        switch ($sort) {
        case 'img': // ʤ
        case 'item': // ȥ
        case 'cbids': // ߲
        case 'bids ': // 
        case 'end': // λ
            parent::set('sort', $sort);
            break;
        default:
            trigger_error("[SyL error] Invalid `sort' property ({$sort}) in `" . __CLASS__ . "' class", E_USER_ERROR);
        }
    }

    /**
     * Ȥνλ򥻥åȤ
     *
     * @access public
     * @param string Ȥνλ
     */
    function setOrder($order)
    {
        switch ($order) {
        case 'a': // 
        case 'd': // ߽
            parent::set('order', $order);
            break;
        default:
            trigger_error("[SyL error] Invalid `order' property ({$order}) in `" . __CLASS__ . "' class", E_USER_ERROR);
        }
    }
}

?>
