<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2008 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_WebServiceTravelSimpleHotelSearchRequest.php,v 1.1 2008/03/01 05:01:22 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * WEBӥ쥹ݥ󥹥饹ʳŷ - ŷȥ٥߸APIѡ
 */
require_once 'SyL_WebServiceTravelSimpleHotelSearchResponse.php';

/**
 * WEBӥ饹ʳŷ - ŷȥ٥߸APIѡ
 *
 * ܺ٤ϡŷ֥ӥ󥿡
 *   http://webservice.rakuten.co.jp/
 * ŷȥ٥߸API 
 *   http://webservice.rakuten.co.jp/api/simplehotelsearch/
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_WebServiceTravelSimpleHotelSearchRequest.php,v 1.1 2008/03/01 05:01:22 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_WebServiceTravelSimpleHotelSearchRequest extends SyL_WebServiceRakuten_co_jpRequest
{
    /**
     * ¹URLѥ
     *
     * @access protected
     * @var string
     */
    var $path = '/rws/1.11/rest';
    /**
     * 쥹ݥ󥹥饹̾
     *
     * @access protected
     * @var string
     */
    var $response_class = 'SyL_WebServiceTravelSimpleHotelSearchResponse';

    /**
     * С򥻥åȤ
     *
     * @access public
     * @param string С
     */
    function setVersion($version)
    {
        parent::set('version', $version);
    }

    /**
     * ʬɤ򥻥åȤ
     *
     * @access public
     * @param string ʬ
     */
    function setLargeClassCode($largeClassCode)
    {
        parent::set('largeClassCode', $largeClassCode);
    }

    /**
     * ʬɤ򥻥åȤ
     *
     * @access public
     * @param string ʬ
     */
    function setMiddleClassCode($middleClassCode)
    {
        parent::set('middleClassCode', $middleClassCode);
    }

    /**
     * ʬɤ򥻥åȤ
     *
     * @access public
     * @param string ʬ
     */
    function setSmallClassCode($smallClassCode)
    {
        parent::set('smallClassCode', $smallClassCode);
    }

    /**
     * ٶʬɤ򥻥åȤ
     *
     * @access public
     * @param string ٶʬ
     */
    function setDetailClassCode($detailClassCode)
    {
        parent::set('detailClassCode', $detailClassCode);
    }

    /**
     * ֹ򥻥åȤ
     *
     * @access public
     * @param int ֹ
     */
    function setHotelNo($hotelNo)
    {
        foreach (explode(',', $hotelNo) as $tmp) {
            if (!preg_match('/^\d+$/', $tmp)) {
                trigger_error("[SyL error] Invalid `hotelNo' property ({$hotelNo}) in `" . __CLASS__ . "' class", E_USER_ERROR);
            }
        }
        parent::set('hotelNo', $hotelNo);
    }

    /**
     * ٤򥻥åȤ
     *
     * @access public
     * @param int 
     */
    function setLatitude($latitude)
    {
        if (preg_match('/^\d+(\.\d+)?$/', $latitude)) {
            parent::set('latitude', $latitude);
        } else {
            trigger_error("[SyL error] Invalid `latitude' property ({$latitude}) in `" . __CLASS__ . "' class", E_USER_ERROR);
        }
    }

    /**
     * ٤򥻥åȤ
     *
     * @access public
     * @param int 
     */
    function setLongitude($longitude)
    {
        if (preg_match('/^\d+(\.\d+)?$/', $longitude)) {
            parent::set('longitude', $longitude);
        } else {
            trigger_error("[SyL error] Invalid `longitude' property ({$longitude}) in `" . __CLASS__ . "' class", E_USER_ERROR);
        }
    }

    /**
     * Ⱦ¤򥻥åȤ
     *
     * @access public
     * @param int Ⱦ (0.1ʾ塢3.0ʲ)
     */
    function setSearchRadius($searchRadius)
    {
        if (preg_match('/^\d(\.\d)?$/', $searchRadius) && ((float)$searchRadius >= 0.1) && ((float)$searchRadius <= 3.0)) {
            parent::set('searchRadius', $searchRadius);
        } else {
            trigger_error("[SyL error] Invalid `searchRadius' property ({$searchRadius}) in `" . __CLASS__ . "' class", E_USER_ERROR);
        }
    }

    /**
     * ʹ߾򥻥åȤ
     *
     * @access public
     * @param string ʹ߾
     */
    function setSqueezeCondition($squeezeCondition)
    {
        foreach (explode(',', $squeezeCondition) as $tmp) {
            switch ($tmp) {
            case 'kinen':
            case 'internet':
            case 'daiyoku':
            case 'onsen':
                break;
            default:
                trigger_error("[SyL error] Invalid `squeezeCondition' property ({$squeezeCondition}) in `" . __CLASS__ . "' class", E_USER_ERROR);
            }
        }
        parent::set('squeezeCondition', $squeezeCondition);
    }

    /**
     * ꥢ򥻥åȤ
     *
     * @access public
     * @param int ꥢ
     */
    function setCarrier($carrier)
    {
        switch ((string)$carrier) {
        case '0':
        case '1':
            parent::set('carrier', $carrier);
            break;
        default:
            trigger_error("[SyL error] Invalid `carrier' property ({$carrier}) in `" . __CLASS__ . "' class", E_USER_ERROR);
        }
    }

    /**
     * 򥻥åȤ
     *
     * @access public
     * @param int 
     */
    function setHits($hits)
    {
        if (preg_match('/^\d+$/', $hits)) {
            parent::set('hits', $hits);
        } else {
            trigger_error("[SyL error] Invalid `hits' property ({$hits}) in `" . __CLASS__ . "' class", E_USER_ERROR);
        }
    }

    /**
     * ٷ٥פ򥻥åȤ
     *
     * @access public
     * @param int  ٷ٥
     */
    function setDatumType($datumType)
    {
        switch ((string)$datumType) {
        case '1': // ¬Ϸϡñ̤
        case '2': // ¬Ϸϡñ̤
            parent::set('datumType', $datumType);
            break;
        default:
            trigger_error("[SyL error] Invalid `datumType' property ({$datumType}) in `" . __CLASS__ . "' class", E_USER_ERROR);
        }
    }
}

?>
