<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2008 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_WebServiceWeatherResponse.php,v 1.1 2008/03/01 05:01:22 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * WEBӥ쥹ݥ󥹥饹ʤŷWebӥѡ
 *
 * ܺ٤ϡWeather Hacksʵݥǡۿӥ˻
 *   http://weather.livedoor.com/weather_hacks/
 * ŷWebӥ
 *   http://weather.livedoor.com/weather_hacks/webservice.html
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_WebServiceWeatherResponse.php,v 1.1 2008/03/01 05:01:22 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_WebServiceWeatherResponse extends SyL_WebServiceLivedoor_comResponse
{
    /**
     * ŷǡ
     *
     * @access private
     * @var array
     */
    var $result = array();
    /**
     * ԥݥŷ
     *
     * @access private
     * @var array
     */
    var $pinpoints = array();
    /**
     * 
     *
     * @access private
     * @var array
     */
    var $copyright = array();

    /**
     * XMLǡƼϥɥ᥽å
     *
     * @access protected
     * @param string XMLΥѥ
     * @param string XMLΥ°
     * @param string XMLΥ
     */
    function getElement($current_path, $attribute, $text)
    {
        static $i = -1;

        switch ($current_path) {
        // =============================
        // 
        // =============================
        case '/lwws':
            if (isset($attribute['version'])) {
                $this->result['version'] = $attribute['version'];
            }
            break;
        // ͽȯɽϰ
        case '/lwws/location':
            if (isset($attribute['area'])) {
                $this->result['area'] = $attribute['area'];
            }
            if (isset($attribute['pref'])) {
                $this->result['pref'] = $attribute['pref'];
            }
            if (isset($attribute['city'])) {
                $this->result['city'] = $attribute['city'];
            }
            break;
        // ȥ롦Ф
        case '/lwws/title': $this->result['title'] = $text; break;
        // ꥯȤ줿ǡϰ˳livedoor ŷURL
        case '/lwws/link': $this->result['link'] = $text; break;
        // ͽ
        case '/lwws/forecastday': $this->result['forecastday'] = $text; break;
        // 
        case '/lwws/day': $this->result['day'] = $text; break;
        // ͽ
        case '/lwws/forecastdate': $this->result['forecastdate'] = $text; break;
        // ͽȯɽ
        case '/lwws/publictime': $this->result['publictime'] = $text; break;
        // ŷ졢ޤꡢʤɡ
        case '/lwws/telop': $this->result['telop'] = $text; break;
        // ŷʸ
        case '/lwws/description': $this->result['description'] = $text; break;
        // ŷ
        case '/lwws/image': $this->result['image'] = array(); break;
        // ŷ졢ޤꡢʤɡ
        case '/lwws/image/title': $this->result['image']['title'] = $text; break;
        // ꥯȤ줿ǡϰ˳livedoor ŷURL
        case '/lwws/image/link': $this->result['image']['link'] = $text; break;
        // ŷURL
        case '/lwws/image/url': $this->result['image']['url'] = $text; break;
        // ŷ
        case '/lwws/image/width': $this->result['image']['width'] = $text; break;
        // ŷι⤵
        case '/lwws/image/height': $this->result['image']['height'] = $text; break;
        // 
        case '/lwws/temperature':     $this->result['temperature'] = array(); break;
        case '/lwws/temperature/max': $this->result['temperature']['max'] = array(); break;
        case '/lwws/temperature/min': $this->result['temperature']['min'] = array(); break;
        // ǹⵤ
        case '/lwws/temperature/max/celsius':    $this->result['temperature']['max']['celsius']['C'] = $text; break;
        case '/lwws/temperature/max/fahrenheit': $this->result['temperature']['max']['celsius']['F'] = $text; break;
        // 㵤
        case '/lwws/temperature/min/celsius':    $this->result['temperature']['min']['celsius']['C'] = $text; break;
        case '/lwws/temperature/min/fahrenheit': $this->result['temperature']['min']['celsius']['F'] = $text; break;

        // ԥݥŷͽ
        case '/lwws/pinpoint/location': $i++; break;
        // ԶĮ¼̾
        case '/lwws/pinpoint/location/title': $this->pinpoints[$i]['title'] = $text; break;
        // бlivedoor ŷURL
        case '/lwws/pinpoint/location/link': $this->pinpoints[$i]['link'] = $text; break;
        // ԥݥŷͽȯɽ
        case '/lwws/pinpoint/location/publictime': $this->pinpoints[$i]['publictime'] = $text; break;

        // ԡ饤Ȥʸ
        case '/lwws/copyright/title': $this->copyright['title'] = $text; break;
        // livedoor ŷURL
        case '/lwws/copyright/link': $this->copyright['link'] = $text; break;
        // livedoor ŷؤURLʤ
        case '/lwws/copyright/image': $this->copyright['image'] = array(); break;
        case '/lwws/copyright/image/title':  $this->copyright['image']['title']  = $text; break;
        case '/lwws/copyright/image/link':   $this->copyright['image']['link']   = $text; break;
        case '/lwws/copyright/image/url':    $this->copyright['image']['url']    = $text; break;
        case '/lwws/copyright/image/width':  $this->copyright['image']['width']  = $text; break;
        case '/lwws/copyright/image/height': $this->copyright['image']['height'] = $text; break;
        // livedoor ŷǻѤƤ뵤ݥǡۿ
        case '/lwws/copyright/provider': $this->copyright['provider'][] = $text; break;

        }
    }

    /**
     * ŷǡ
     *
     * @access public
     * @param string ̾
     * @return mixed ŷǡ
     */
    function getResult($name=null)
    {
        if ($name !== null) {
            return isset($this->result[$name]) ? $this->result[$name] : null;
        } else {
            return $this->result;
        }
    }

    /**
     * ԥݥŷ󥯾
     *
     * @access public
     * @return array ԥݥŷ󥯾
     */
    function getPinpoints()
    {
        return $this->pinpoints;
    }

    /**
     * 
     *
     * @access public
     * @param string ̾
     * @return mixed 
     */
    function getCopyright($name=null)
    {
        if ($name !== null) {
            return isset($this->copyright[$name]) ? $this->copyright[$name] : null;
        } else {
            return $this->copyright;
        }
    }
}

?>
