<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2008 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_DBPdo.php,v 1.5 2008/01/15 09:19:04 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 *  DB饹PDO
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_DBPdo.php,v 1.5 2008/01/15 09:19:04 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
abstract class SyL_DBPdo extends SyL_DB
{
    /**
     * PDO DB³¹
     * 
     * @access public
     * @param string ³ʸ
     * @param string 桼̾
     * @param string ѥ
     * @return boolean ³OK: true, ³NG: false
     */
    protected function pdoConnection($conn_string, $conn_user=null, $conn_passwd=null)
    {
        try {
            if (($conn_user !== null) && ($conn_passwd !== null)) {
                $this->connection = new PDO($conn_string, $conn_user, $conn_passwd);
            } else if ($conn_user !== null) {
                $this->connection = new PDO($conn_string, $conn_user);
            } else {
                $this->connection = new PDO($conn_string);
            }
            switch ($this->field_case) {
            case CASE_UPPER: $this->connection->setAttribute(PDO::ATTR_CASE, PDO::CASE_UPPER); break;
            case CASE_LOWER: $this->connection->setAttribute(PDO::ATTR_CASE, PDO::CASE_LOWER); break;
            }
        } catch (PDOException $e) {
            $this->setErrorMessage($e->getCode(), $e->getMessage());
            $this->triggerError();
        }

        return is_object($this->connection);
    }

    /**
     * DB³λ
     * 
     * @access public
     */
    public function closeConnection()
    {
        $this->connection = null;
    }

    /**
     * ѥ᡼˥̵˽
     * 
     * @access public
     * @param string ˥оʸ
     * @return string ˥ʸ
     */
    public function quote($parameter)
    {
        return $this->connection->quote($parameter);
    }

    /**
     * ȥ󥶥󳫻
     *
     * @access public
     */
    public function beginTransaction()
    {
        $result = true;
        parent::beginTransaction();
        try {
            $this->connection->beginTransaction();
        } catch (PDOException $e) {
            $this->setErrorMessage($e->getCode(), $e->getMessage());
            $result = false;
        }
        return $result;
    }

    /**
     * ȥ󥶥˴
     *
     * @access public
     */
    public function rollBack()
    {
        $result = true;
        try {
            $this->connection->rollBack();
        } catch (PDOException $e) {
            $result = false;
        }
        parent::rollBack();
        return $result;
    }

    /**
     * ȥ󥶥
     *
     * @access public
     */
    public function commit()
    {
        $result = true;
        try {
            $this->connection->commit();
        } catch (PDOException $e) {
            $result = false;
        }
        parent::commit();
        return $result;
    }

    /**
     * Ǹ˵ä顼å򥻥å
     *
     * @access public
     * @param string 顼
     * @param string 顼å
     */
    function setErrorMessage($code='', $message='')
    {
        if ($message) {
            parent::setErrorMessage($code, $message);
        } else {
            if (method_exists($this->connection, 'errorInfo')) {
                $error_info = $this->connection->errorInfo();
                if (isset($error_info[1])) {
                    $this->last_error_code    = $error_info[1] . "(" . $error_info[0] . ")";
                    $this->last_error_message = $error_info[2];
                } else {
                    $this->last_error_code    = $error_info[0];
                }
            }
        }
    }

    /**
     * SQL¹ԤDB꥽
     *
     * @access public
     * @param string SQLʸ
     * @return mixed ¹OK: DB꥽, ¹NG: false
     */
    public function execSelect($sql)
    {
        try {
            $stmt = $this->connection->query($sql);
            if ($stmt === false) {
                $this->setErrorMessage();
                $this->triggerError();
            }
            return $stmt;
        } catch (PDOException $e) {
            $this->setErrorMessage($e->getCode(), $e->getMessage());
            $this->triggerError();
            return false;
        }
    }

    /**
     * SQL¹Ԥ¹Է̱ƶ
     *
     * @access public
     * @param string SQLʸ
     * @return mixed ¹OK: ¹Է̱ƶ, ¹NG: false
     */
    public function execUpdate($sql)
    {
        try {
            $result = $this->connection->exec($sql);
            if ($result === false) {
                $this->setErrorMessage();
                $this->triggerError();
            }
            return $result;
        } catch (PDOException $e) {
            $this->setErrorMessage($e->getCode(), $e->getMessage());
            $this->triggerError();
            return false;
        }
    }

    /**
     * SQL¹ԤΤ
     *
     * @access public
     * @param string SQLʸ
     * @return boolean ¹OK: true, ¹NG: false
     */
    public function execNoReturn($sql)
    {
        return $this->execUpdate($sql);
    }
  
    /**
     * SQL¹Ԥ̥ǡ
     *
     * 3ѥ᡼'one'ξ
     *    ǽ1ʸȤƼ
     * 3ѥ᡼'record'ξ
     *    ǽ1쥳ɤȤƼ
     * 3ѥ᡼'all'ξ
     *    쥳ɤȤƼ
     *
     * @access public
     * @param string SQLʸ
     * @param mixed  ¹Է̤
     * @param string ̼ե饰
     * @return boolean ¹OK: true, ¹NG: false
     */
    public function queryRef($sql, &$data, $get='all')
    {
        // SQL¹
        $this->execRef($sql, $stmt);

        // Ƚ
        if (!is_object($stmt)) {
            $data = $stmt;
            return ($stmt !== false);
        }

        switch ($get) {
        // 1ե
        case 'one':
            $row = $stmt->fetch(PDO::FETCH_NUM);
            $data = $row ? $row[0] : '';
            break;
        // 1쥳
        case 'record':
            $data = $stmt->fetch(PDO::FETCH_ASSOC);
            if ($data === false) {
                $data = array();
            }
            break;
        // 쥳
        case 'all':
            $data = $stmt->fetchAll(PDO::FETCH_ASSOC);
            break;
        }
        return $stmt->closeCursor();
    }

    /**
     * Ǹ줿Ԥ ID 뤤ϥ󥹤ͤ
     *
     * @access public
     * @return int Ǹ줿ԤID
     */
    public function lastInsertId($seq=null)
    {
        if ($seq === null) {
            return $this->connection->lastInsertId();
        } else {
            return $this->connection->lastInsertId($seq);
        }
    }
}

?>
