<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2008 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_DataJs.php,v 1.8 2008/07/10 15:17:43 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * JavaScriptǡݻ饹
 * 
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_DataJs.php,v 1.8 2008/07/10 15:17:43 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_DataJs extends SyL_Data
{
    /**
     * JavaScriptϾ
     * 
     * @access private
     * @var string
     */
    var $javascript = '';
    /**
     * JavaScriptϥ饹
     * 
     * @access private
     * @var array
     */
    var $imports = array();
    /**
     * ݡȥѥ᡼̾
     *
     * @access private
     * @var string
     */
    var $import_parameter = SYL_JS_AUTO_IMPORT_PARAMETER;
    /**
     * ݡȥեʬ
     *
     * @access private
     * @var string
     */
    var $separater = SYL_JS_AUTO_IMPORT_SEPARATER;
    /**
     * JSONPХåؿ̾
     * 
     * @access private
     * @var array
     */
    var $js_callback = '';
    /**
     * JSONPХåѥ᡼̾
     *
     * @access private
     * @var string
     */
    var $js_callback_parameter = 'callback';

    /**
     * JSONPХåؿ򥻥å
     * 
     * @access public
     * @param string JSONPХåؿ
     */
    function setJsCallback($js_callback)
    {
        $this->js_callback = $js_callback;
    }

    /**
     * JSONPХåؿ
     * 
     * @access public
     * @return string JSONPХåؿ
     */
    function getJsCallback()
    {
        return $this->js_callback;
    }

    /**
     * JavaScriptϾ򥻥å
     * 
     * @access public
     * @param string JavaScriptϾ
     */
    function setJs($javascript)
    {
        $this->javascript = $javascript;
    }

    /**
     * JavaScriptϾ
     * 
     * @access public
     * @return string JavaScriptϾ
     */
    function getJs()
    {
        return $this->javascript;
    }

    /**
     * ϥ饹ɲ
     * 
     * @access public
     * @param string ϥ饹
     */
    function addImport($import)
    {
        $this->imports = array_merge($this->imports, (array)$import);
    }

    /**
     * ϥ饹
     * 
     * @access public
     * @return array ϥ饹
     */
    function getImport()
    {
        return $this->imports;
    }

    /**
     * JSݡȥѥ᡼򥻥å
     * 
     * @access protected
     */
    function setImportParameter()
    {
        $js = $this->get($this->import_parameter);
        if ($js) {
            foreach (explode($this->separater, $js) as $import) {
                $this->addImport($import);
            }
        }
    }

    /**
     * ϥѥ᡼򥻥å
     * 
     * @access protected
     */
    function initInputs()
    {
        // ѥ᡼
        $this->setInputs(($_SERVER['REQUEST_METHOD'] == 'POST') ? $_POST + $_GET : $_GET + $_POST);
        // ϥ󥳡ǥ󥰤Ѵ
        $this->apply('mb_convert_encoding', SYL_ENCODE_INTERNAL, SYL_ENCODE_JS);
        // ޥåݥȤͭȽ
        if (get_magic_quotes_gpc()) {
            $this->apply('stripslashes');
        }
        // ʸɥåɲ
        if (function_exists('mb_check_encoding')) {
            $this->applyCheckEncodingRecursive($this->input_parameters, SYL_ENCODE_INTERNAL);
        }

        // JSݡȥѥ᡼
        if ($this->import_parameter) {
            $this->setImportParameter();
        }
        // JSONPХåؿѥ᡼
        $js_callback = $this->get($this->js_callback_parameter);
        if (is_string($js_callback)) {
            // Хåؿå
            if (preg_match('/^[a-zA-Z0-9_\$\.\[\]]+$/', $js_callback)) {
                $this->js_callback = $js_callback;
            } else {
                trigger_error("[SyL error] Invalid javascript callback function ({$js_callback})", E_USER_ERROR);
            }
        }
    }

    /**
     * ǸŪ˥ѥ᡼᥽å
     * 
     * @access public
     * @return array ѥ᡼
     */
    function finalOutputs()
    {
        // ϥ󥳡ǥ󥰤Ѵ
        $this->apply('mb_convert_encoding', SYL_ENCODE_JS, SYL_ENCODE_INTERNAL);
        $parameters = $this->gets(false);
        $this->deletes();
        return $parameters;
    }
}

?>
