<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2008 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_AdmFlowUpd.php,v 1.9 2008/06/20 17:41:54 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * եδ쥯饹
 */
require_once SYL_INCLUDE_DIR . '/framework/Adm/SyL_AdmFlow.php';

/**
 * ե饹
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_AdmFlowUpd.php,v 1.9 2008/06/20 17:41:54 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_AdmFlowUpd extends SyL_AdmFlow
{
    /**
     * ڥ졼̾
     *
     * @access protected
     * @var string
     */
    var $opp_name = 'upd';

    /**
     * 󥹥ȥ饯
     *
     * @access public
     */
    function SyL_AdmFlowUpd()
    {
        parent::SyL_AdmFlow();
    }

    /**
     * ե
     *
     * @access public
     * @param object ǡ֥
     * @param object ƥȴ֥
     */
    function execute(&$data, &$context)
    {
        // ե
        $form =& $this->getForm();
        // 祭ѥ᡼̾
        $key_name = $form->getStructConfig('key_name');
        // ѥ᡼
        $key = $data->get($key_name);
        if (($key === null) || ($key === '')) {
            // Բ
            SyL_Response::redirect($this->getUrl('lst'));
        }

        // DB³
        $conn =& $context->getDB();
        // ADM֥Ⱥ
        $adm  =& SyL_Adm::factory($form, $conn, array($key));
        // ơ֥
        $adm->loadConfig();
        // å
        if (!$adm->isUpd()) {
            // Բ
            SyL_Response::redirect($this->getUrl('lst'));
        }

        // ɽΤ
        $read_only = '';
        if (!$data->get('adm_action_exe')) {
            $read_only = $data->get('adm_read_only');
            if ($read_only) {
                foreach (explode("\t", $read_only) as $column) {
                    $form->setReadOnlyColumn($column);
                }
            }
        }

        // Ϣǡ󥯤ѥ
        list($pu, $cu, $nu) = $this->getLocations($data->get('adm_u'));

        // ʬ
        if ($context->isPost()) {
            // ǡ֥ȥå
            $form->registerInput($data);
            // ե๽
            $form->build();

            // ؿʤ
            if ($data->get('adm_action_next')) {
                // Хǡ¹
                if ($this->validateAdm($adm)) {
                    // ǧ̤
                    $form->setReadOnly(true);
                }
            } else if ($data->get('adm_action_exe')) {
                // Хǡ¹
                if ($this->validateAdm($adm)) {
                    // ¹
                    if (!$this->update($adm)) {
                        trigger_error("[Adm error] Can't Update Opperation", E_USER_ERROR);
                    }
                    // λ̤إ쥯
                    SyL_Response::redirect($this->getUrl('fin') . '?adm_action=upd&adm_u=' . urlencode($data->get('adm_u')));
                }
            } else if ($data->get('adm_action_prev')) {
                // ǧ̤
            }
        } else {
            // ɽ
            $result = $adm->getRecord();
            if ($result == null) {
                SyL_Response::redirect($this->getUrl('lst'));
            }
            // ¸ǡå
            $data->sets($result);
            // ǡ֥ȥå
            $form->registerInput($data);
            // ե๽
            $form->build();
        }

        // 祭ѥ᡼
        $key_value = $adm->getKeyQuery();

        // DB³λ
        $context->closeDB($conn);

        // եǥǡ
        $data->set('form',      $form->getResultArray());
        $data->set('read_only', $read_only);
        // 祭ѥ᡼
        $data->set('key_name',  $key_name);
        $data->set('key_value', $key_value);
        // ǧɽϢ
        $data->set('view_alert',   $form->getStructConfig('view_alert'));
        $data->set('view_confirm', $form->getStructConfig('view_confirm'));

        // ʸϢ
        $data->set('title', $form->getStructConfig('title'));

        // URL
        $data->set('url_lst', $this->getUrl('lst'));
        $data->set('url_upd', $this->getUrl('upd'));
        $data->set('url_dir', dirname($this->getScriptName()));
        $data->set('url_lst_u', $this->getUrl('lst', $pu));

        // Ϣǡ󥯤ѥ
        $data->set('cu',  $cu);
        $data->set('cuu', $data->get('adm_u'));
    }

    /**
     * Хǡ¹
     *
     * @access public
     * @param object ADM֥
     * @return bool true: ХǡOKfalse: Хǡ󥨥顼
     */
    function validateAdm(&$adm)
    {
        return $adm->validateAdm();
    }

    /**
     * ¹
     *
     * @access public
     * @param object ADM֥
     */
    function update(&$adm)
    {
        return $adm->update();
    }
}

?>
