<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2008 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_WebServiceTextKouseiRequest.php,v 1.1 2008/03/29 06:11:46 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * WEBӥ쥹ݥ󥹥饹Yahoo! Japan - ٱWebӥ
 */
require_once 'SyL_WebServiceTextKouseiResponse.php';

/**
 * WEBӥꥯȥ饹Yahoo! Japan - ٱWebӥ
 *
 * ܺ٤ϡYahoo!ǥ٥åѡͥåȥ
 *   http://developer.yahoo.co.jp/
 * ٱWebӥ
 *   http://developer.yahoo.co.jp/jlp/KouseiService/V1/kousei.html
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_WebServiceTextKouseiRequest.php,v 1.1 2008/03/29 06:11:46 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_WebServiceTextKouseiRequest extends SyL_WebServiceYahoo_co_jpRequest
{
    /**
     * WEBӥСΥۥ̾
     *
     * @access protected
     * @var string
     */
    var $host = 'jlp.yahooapis.jp';
    /**
     * ¹URLѥ
     *
     * @access protected
     * @var string
     */
    var $path = '/KouseiService/V1/kousei';
    /**
     * 쥹ݥ󥹥饹̾
     *
     * @access protected
     * @var string
     */
    var $response_class = 'SyL_WebServiceTextKouseiResponse';

    /**
     * оݤΥƥȤ򥻥åȤ
     *
     * @access public
     * @param string оݤΥƥ
     */
    function setSentence($sentence)
    {
        parent::set('sentence', $sentence);
    }

    /**
     * Ŧ롼פֹ򥳥ޤǶڤäƤ򥻥åȤ
     *
     * @access public
     * @param string Ŧ롼פֹ
     */
    function setFilter_group($filter_group)
    {
        foreach (array_map('trim', explode(',', $filter_group)) as $tmp) {
            switch ($tmp) {
            case '1':
            case '2':
            case '3':
                break;
            default:
                trigger_error("[SyL error] Invalid `filter_group' property ({$filter_group}) in `" . __CLASS__ . "' class", E_USER_ERROR);
            }
        }
        parent::set('filter_group', $filter_group);
    }

    /**
     * filter_groupǻꤷŦ롼פŦ򥻥åȤ
     *
     * @access public
     * @param string filter_groupǻꤷŦ롼פŦ
     */
    function setNo_filter($no_filter)
    {
        foreach (array_map('trim', explode(',', $no_filter)) as $tmp) {
            if (!is_numeric($tmp) || (($tmp < 1) || ($tmp > 17))) {
                trigger_error("[SyL error] Invalid `no_filter' property ({$no_filter}) in `" . __CLASS__ . "' class", E_USER_ERROR);
            }
        }
        parent::set('response', $response);
    }
}

?>
