<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2008 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_WebServiceTextConversionRequest.php,v 1.1 2008/06/20 17:41:54 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * WEBӥ쥹ݥ󥹥饹Yahoo! Japan - ʴѴWebӥ
 */
require_once 'SyL_WebServiceTextConversionResponse.php';

/**
 * WEBӥꥯȥ饹Yahoo! Japan - ʴѴWebӥ
 *
 * ܺ٤ϡYahoo!ǥ٥åѡͥåȥ
 *   http://developer.yahoo.co.jp/
 * ʴѴWebӥ
 *   http://developer.yahoo.co.jp/jlp/JIMService/V1/conversion.html
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_WebServiceTextConversionRequest.php,v 1.1 2008/06/20 17:41:54 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_WebServiceTextConversionRequest extends SyL_WebServiceYahoo_co_jpRequest
{
    /**
     * WEBӥСΥۥ̾
     *
     * @access protected
     * @var string
     */
    var $host = 'jlp.yahooapis.jp';
    /**
     * ¹URLѥ
     *
     * @access protected
     * @var string
     */
    var $path = '/JIMService/V1/conversion';
    /**
     * 쥹ݥ󥹥饹̾
     *
     * @access protected
     * @var string
     */
    var $response_class = 'SyL_WebServiceTextConversionResponse';

    /**
     * оݤΥƥȤ򥻥åȤ
     *
     * @access public
     * @param string оݤΥƥ
     */
    function setSentence($sentence)
    {
        parent::set('sentence', $sentence);
    }

    /**
     * sentenceΥƥȥեޥåȤ򥻥åȤ
     *
     * @access public
     * @param string sentenceΥƥȥեޥå
     */
    function setFormat($format)
    {
        switch ($format) {
        case 'roman':
            break;
        default:
            trigger_error("[SyL error] Invalid `format' property ({$format}) in `" . __CLASS__ . "' class", E_USER_ERROR);
        }
        parent::set('format', $format);
    }

    /**
     * ʴѴ̾Ѵ޻Ѵ¬ѴΤŤ줫򥻥åȤ
     *
     * @access public
     * @param string ʴѴ̾Ѵ޻Ѵ¬ѴΤŤ줫
     */
    function setMode($mode)
    {
        switch ($mode) {
        case 'normal':
        case 'roman':
        case 'predictive':
            break;
        default:
            trigger_error("[SyL error] Invalid `mode' property ({$mode}) in `" . __CLASS__ . "' class", E_USER_ERROR);
        }
        parent::set('mode', $mode);
    }

    /**
     * ̾ΤʴѴΤۤˡѴֵͤ򥻥åȤ
     *
     * @access public
     * @param string ̾ΤʴѴΤۤˡѴֵ
     */
    function setResponse($response)
    {
        foreach (array_map('trim', explode(',', $response)) as $tmp) {
            switch ($tmp) {
            case 'katakana':
            case 'hiragana':
            case 'alphanumeric':
            case 'half_katakana':
            case 'half_alphanumeric':
                break;
            default:
                trigger_error("[SyL error] Invalid `response' property ({$response}) in `" . __CLASS__ . "' class", E_USER_ERROR);
            }
        }
        parent::set('response', $response);
    }

    /**
     * ѴѤμ򥻥åȤ
     *
     * @access public
     * @param string ѴѤμ
     */
    function setDictionary($dictionary)
    {
        foreach (array_map('trim', explode(',', $dictionary)) as $tmp) {
            switch ($tmp) {
            case 'default':
            case 'name':
            case 'place':
            case 'zip':
            case 'symbol':
                break;
            default:
                trigger_error("[SyL error] Invalid `dictionary' property ({$dictionary}) in `" . __CLASS__ . "' class", E_USER_ERROR);
            }
        }
        parent::set('dictionary', $dictionary);
    }

    /**
     * ʸñ̤Ѵο򥻥åȤ
     *
     * @access public
     * @param int ʸñ̤Ѵο
     */
    function setResults($results)
    {
        if (preg_match('/^\d+$/', $results) && (($results >= 1) && ($results <= 999))) {
            parent::set('results', $results);
        } else {
            trigger_error("[SyL error] Invalid `results' property ({$results}) in `" . __CLASS__ . "' class", E_USER_ERROR);
        }
    }
}

?>
