<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2008 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_TemplateXslt.php,v 1.1 2008/06/20 17:41:54 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * XSLTŬѥ饹
 */
require_once dirname(__FILE__) . '/../Xml/SyL_XmlXslt.php';

/** 
 * XSLTƥץ졼ȥ饹
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_TemplateXslt.php,v 1.1 2008/06/20 17:41:54 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_TemplateXslt extends SyL_Template
{
    /**
     * XMLե
     *
     * @access private
     * @var string
     */
    var $xml_file = '';

    /**
     * XMLե򥻥å
     *
     * @access public
     * @param string XMLե
     */
    function setXmlFile($xml_file)
    {
        $this->xml_file = $xml_file;
    }

    /**
     * ƥץ졼ȤŬѤ
     *
     * @access public
     * @return string ƥץ졼ŬѸǡ
     */
    function render()
    {
        $xslt =& new SyL_XmlXslt($this->template_file, $this->xml_file);
        if (!$this->xml_file) {
            // XML̵硢ߡǡ򥻥å
            $xslt->setXml('<?xml version="1.0" encoding="UTF-8"?><root></root>', true);
        }

        $xslt->sets($this->gets());
        // ֥ƥץ졼Ŭ
        $xslt->sets($this->renderChild());
        return $xslt->transform();
    }
}

?>
