<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2008 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_XmlEntry.php,v 1.3 2008/01/15 09:19:03 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * ݥåȥѥ˴Ť쥯饹
 */
require_once dirname(__FILE__) . '/../Util/Composite/SyL_UtilCompositeComponent.php';

/** 
 * XMLĥ꡼쥯饹
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_XmlEntry.php,v 1.3 2008/01/15 09:19:03 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_XmlEntry extends SyL_UtilCompositeComponent
{
    /**
     * ƥ
     * 
     * @access protected
     * @var string
     */
    var $text = null;
    /**
     * CDATAե饰
     * 
     * @access protected
     * @var bool
     */
    var $cdata = false;
    /**
     * 
     * 
     * @access protected
     * @var bool
     */
    var $comment = null;
    /**
     * 
     * 
     * @access protected
     * @var string
     */
    var $eol = "\r\n";

    /**
     * 󥹥ȥ饯
     *
     * @access public
     * @param string ̾
     * @param array °
     * @param string 
     * @param bool CDATAե饰
     */
    function SyL_XmlEntry($name=null, $attributes=array(), $text='', $cdata=false)
    {
        parent::SyL_UtilCompositeComponent($name, $attributes);
        $this->text  = $text;
        $this->cdata = $cdata;
    }

    /**
     * Ȥɲä
     *
     * @access public
     * @param string 
     */
    function addComment($comment)
    {
        $this->comment = $comment;
    }

    /**
     * XMLǤ
     *
     * @access public
     * @param bool ԥե饰
     * @return string XML
     */
    function getTree($is_eol=false)
    {
        $element  = '';
        if ($this->comment !== null) {
            $element .= '<!--';
            $element .= htmlspecialchars($this->comment);
            $element .= '-->';
        }

        $element .= "<{$this->name}";
        foreach ($this->getAttributes() as $name => $value) {
            $element .= ' ' . $name . '="' . htmlspecialchars($value) . '"';
        }
        if ($this->text !== null) {
            $element .= '>';
            if ($this->cdata) {
                $element .= '<![CDATA[' . htmlspecialchars($this->text) . ']]>';
            } else {
                $element .= htmlspecialchars($this->text);
            }
            $element .= "</{$this->name}>";
        } else {
            $element .= '/>';
        }
        if ($is_eol) {
            $element .= $this->eol;
        }

        return $element;
    }
}

?>
