<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2008 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_WebServiceKadenProductItemResponse.php,v 1.1 2008/02/02 14:40:45 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * WEBӥ쥹ݥ󥹥饹Yahoo! Japan - ʾѡ
 *
 * ܺ٤ϡYahoo!ǥ٥åѡͥåȥ
 *   http://developer.yahoo.co.jp/
 * ʾ
 *   http://developer.yahoo.co.jp/kaden/productitem/v1/productitem.html
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_WebServiceKadenProductItemResponse.php,v 1.1 2008/02/02 14:40:45 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_WebServiceKadenProductItemResponse extends SyL_WebServiceYahoo_co_jpResponse
{
    /**
     * ̥ǡ
     *
     * @access private
     * @var array
     */
    var $result = array();

    /**
     * XMLǡƼϥɥ᥽å
     *
     * @access protected
     * @param string XMLΥѥ
     * @param string XMLΥ°
     * @param string XMLΥ
     */
    function getElement($current_path, $attribute, $text)
    {
        static $spec_i = -1;

        switch ($current_path) {
        // =============================
        // 
        // =============================
        // IDʥץID
        case '/ProductResultSet/ProductResult/ProductID': $this->result['ProductID'] = $text; break;
        // ̾
        case '/ProductResultSet/ProductResult/ProductName': $this->result['ProductName'] = $text; break;
        // ȯ丵
        case '/ProductResultSet/ProductResult/MakerName': $this->result['MakerName'] = $text; break;
        // ƥ̾
        case '/ProductResultSet/ProductResult/CategoryName': $this->result['CategoryName'] = $text; break;
        // ƥǤΥ󥭥󥰽
        case '/ProductResultSet/ProductResult/PyRanking': $this->result['PyRanking'] = $text; break;
        // ʲURL
        case '/ProductResultSet/ProductResult/ImageUrl': $this->result['ImageUrl'] = $text; break;
        // ʾURL
        case '/ProductResultSet/ProductResult/ItemPageUrl': $this->result['ItemPageUrl'] = $text; break;
        // ǰ
        case '/ProductResultSet/ProductResult/LowestPrice': $this->result['LowestPrice'] = $text; break;
        // ߤΥڡURL
        case '/ProductResultSet/ProductResult/ReviewUrl': $this->result['ReviewUrl'] = $text; break;
        // ƿ
        case '/ProductResultSet/ProductResult/ReviewResults': $this->result['ReviewResults'] = $text; break;
        // ʿѺ
        case '/ProductResultSet/ProductResult/ReviewRating': $this->result['ReviewRating'] = $text; break;
        // ʳ
        case '/ProductResultSet/ProductResult/ProductOutline': $this->result['ProductOutline'] = $text; break;
        // ʤΥڥå
        case '/ProductResultSet/ProductResult/Spec': $spec_i++; break;
        // ڥåܤ̾
        case '/ProductResultSet/ProductResult/Spec/SpecName': $this->result['Spec'][$spec_i]['SpecName'] = $text; break;
        // ڥå
        case '/ProductResultSet/ProductResult/Spec/SpecValue': $this->result['Spec'][$spec_i]['SpecValue'] = $text; break;
        // ڥåñ
        case '/ProductResultSet/ProductResult/Spec/SpecUnit': $this->result['Spec'][$spec_i]['SpecUnit'] = $text; break;
        // Ϣ ID
        case '/ProductResultSet/ProductResult/RProductID': $this->result['RProductID'][] = $text; break;

        // ¾
        default: parent::getElement($current_path, $attribute, $text); break;
        }
    }

    /**
     * ʤ
     *
     * @access public
     * @return int ʤ
     */
    function getTotalProducts()
    {
        return $this->total_products;
    }

    /**
     * ڡ
     *
     * @access public
     * @return int ڡ
     */
    function getTotalPage()
    {
        return $this->total_page;
    }

    /**
     * ߤΥڡֹ
     *
     * @access public
     * @return int ߤΥڡֹ
     */
    function getCurPage()
    {
        return $this->cur_page;
    }

    /**
     * ʾ
     *
     * @access public
     * @return mixed ʾ
     */
    function getResult($name=null)
    {
        if ($name !== null) {
            return isset($this->result[$name]) ? $this->result[$name] : null;
        } else {
            return $this->result;
        }
    }
}

?>
