<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2008 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_WebServiceTravelVacantHotelSearchRequest.php,v 1.1 2008/03/01 05:01:22 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * WEBӥ쥹ݥ󥹥饹ʳŷ - ŷȥ٥APIѡ
 */
require_once 'SyL_WebServiceTravelVacantHotelSearchResponse.php';

/**
 * WEBӥ饹ʳŷ - ŷȥ٥APIѡ
 *
 * ܺ٤ϡŷ֥ӥ󥿡
 *   http://webservice.rakuten.co.jp/
 * ŷȥ٥API 
 *   http://webservice.rakuten.co.jp/api/vacanthotelsearch/
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_WebServiceTravelVacantHotelSearchRequest.php,v 1.1 2008/03/01 05:01:22 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_WebServiceTravelVacantHotelSearchRequest extends SyL_WebServiceRakuten_co_jpRequest
{
    /**
     * ¹URLѥ
     *
     * @access protected
     * @var string
     */
    var $path = '/rws/1.11/rest';
    /**
     * 쥹ݥ󥹥饹̾
     *
     * @access protected
     * @var string
     */
    var $response_class = 'SyL_WebServiceTravelVacantHotelSearchResponse';

    /**
     * С򥻥åȤ
     *
     * @access public
     * @param string С
     */
    function setVersion($version)
    {
        parent::set('version', $version);
    }

    /**
     * ʬɤ򥻥åȤ
     *
     * @access public
     * @param string ʬ
     */
    function setLargeClassCode($largeClassCode)
    {
        parent::set('largeClassCode', $largeClassCode);
    }

    /**
     * ʬɤ򥻥åȤ
     *
     * @access public
     * @param string ʬ
     */
    function setMiddleClassCode($middleClassCode)
    {
        parent::set('middleClassCode', $middleClassCode);
    }

    /**
     * ʬɤ򥻥åȤ
     *
     * @access public
     * @param string ʬ
     */
    function setSmallClassCode($smallClassCode)
    {
        parent::set('smallClassCode', $smallClassCode);
    }

    /**
     * ٶʬɤ򥻥åȤ
     *
     * @access public
     * @param string ٶʬ
     */
    function setDetailClassCode($detailClassCode)
    {
        parent::set('detailClassCode', $detailClassCode);
    }

    /**
     * ֹ򥻥åȤ
     *
     * @access public
     * @param int ֹ
     */
    function setHotelNo($hotelNo)
    {
        foreach (explode(',', $hotelNo) as $tmp) {
            if (!preg_match('/^\d+$/', $tmp)) {
                trigger_error("[SyL error] Invalid `hotelNo' property ({$hotelNo}) in `" . __CLASS__ . "' class", E_USER_ERROR);
            }
        }
        parent::set('hotelNo', $hotelNo);
    }

    /**
     * åǯ򥻥åȤ
     *
     * @access public
     * @param string åǯ
     */
    function setCheckinDate($checkinDate)
    {
        $date = explode('-', $checkinDate);
        if (count($date) != 3) {
            trigger_error("[SyL error] Invalid `checkinDate' property ({$checkinDate}) in `" . __CLASS__ . "' class", E_USER_ERROR);
        }
        foreach ($date as $tmp) {
            if (!preg_match('/^\d+$/', $tmp)) {
                trigger_error("[SyL error] Invalid `checkinDate' property ({$checkinDate}) in `" . __CLASS__ . "' class", E_USER_ERROR);
            }
        }
        if (checkdate($date[1], $date[2], $date[0])) {
            parent::set('checkinDate', $checkinDate);
        } else {
            trigger_error("[SyL error] Invalid `checkinDate' property ({$checkinDate}) in `" . __CLASS__ . "' class", E_USER_ERROR);
        }
    }

    /**
     * åǯ򥻥åȤ
     *
     * @access public
     * @param string åǯ
     */
    function setCheckoutDate($checkoutDate)
    {
        $date = explode('-', $checkoutDate);
        if (count($date) != 3) {
            trigger_error("[SyL error] Invalid `checkoutDate' property ({$checkoutDate}) in `" . __CLASS__ . "' class", E_USER_ERROR);
        }
        foreach ($date as $tmp) {
            if (!preg_match('/^\d+$/', $tmp)) {
                trigger_error("[SyL error] Invalid `checkoutDate' property ({$checkoutDate}) in `" . __CLASS__ . "' class", E_USER_ERROR);
            }
        }
        if (checkdate($date[1], $date[2], $date[0])) {
            parent::set('checkoutDate', $checkoutDate);
        } else {
            trigger_error("[SyL error] Invalid `checkoutDate' property ({$checkoutDate}) in `" . __CLASS__ . "' class", E_USER_ERROR);
        }
    }

    /**
     * Ϳ()򥻥åȤ
     *
     * @access public
     * @param int Ϳ()
     */
    function setAdultNum($adultNum)
    {
        if (preg_match('/^\d{1,2}$/', $adultNum)) {
            parent::set('adultNum', $adultNum);
        } else {
            trigger_error("[SyL error] Invalid `adultNum' property ({$adultNum}) in `" . __CLASS__ . "' class", E_USER_ERROR);
        }
    }

    /**
     * Ϳ(ǯ)򥻥åȤ
     *
     * @access public
     * @param int Ϳ(ǯ)
     */
    function setUpClassNum($upClassNum)
    {
        if (preg_match('/^\d{1,2}$/', $upClassNum)) {
            parent::set('upClassNum', $upClassNum);
        } else {
            trigger_error("[SyL error] Invalid `upClassNum' property ({$upClassNum}) in `" . __CLASS__ . "' class", E_USER_ERROR);
        }
    }

    /**
     * Ϳ(ǯ)򥻥åȤ
     *
     * @access public
     * @param int Ϳ(ǯ)
     */
    function setLowClassNum($lowClassNum)
    {
        if (preg_match('/^\d{1,2}$/', $lowClassNum)) {
            parent::set('lowClassNum', $lowClassNum);
        } else {
            trigger_error("[SyL error] Invalid `lowClassNum' property ({$lowClassNum}) in `" . __CLASS__ . "' class", E_USER_ERROR);
        }
    }

    /**
     * Ϳ(Ļ())򥻥åȤ
     *
     * @access public
     * @param int Ϳ(Ļ())
     */
    function setInfantWithMBNum($infantWithMBNum)
    {
        if (preg_match('/^\d{1,2}$/', $infantWithMBNum)) {
            parent::set('infantWithMBNum', $infantWithMBNum);
        } else {
            trigger_error("[SyL error] Invalid `infantWithMBNum' property ({$infantWithMBNum}) in `" . __CLASS__ . "' class", E_USER_ERROR);
        }
    }

    /**
     * Ϳ(Ļ(Τ))򥻥åȤ
     *
     * @access public
     * @param int Ϳ(Ļ(Τ))
     */
    function setInfantWithMNum($infantWithMNum)
    {
        if (preg_match('/^\d{1,2}$/', $infantWithMNum)) {
            parent::set('infantWithMNum', $infantWithMNum);
        } else {
            trigger_error("[SyL error] Invalid `infantWithMNum' property ({$infantWithMNum}) in `" . __CLASS__ . "' class", E_USER_ERROR);
        }
    }

    /**
     * Ϳ(Ļ(ĤΤ))򥻥åȤ
     *
     * @access public
     * @param int Ϳ(Ļ(ĤΤ))
     */
    function setInfantWithBNum($infantWithBNum)
    {
        if (preg_match('/^\d{1,2}$/', $infantWithBNum)) {
            parent::set('infantWithBNum', $infantWithBNum);
        } else {
            trigger_error("[SyL error] Invalid `infantWithBNum' property ({$infantWithBNum}) in `" . __CLASS__ . "' class", E_USER_ERROR);
        }
    }

    /**
     * Ϳ(Ļ())򥻥åȤ
     *
     * @access public
     * @param int Ϳ(Ļ())
     */
    function setInfantWithoutMBNum($infantWithoutMBNum)
    {
        if (preg_match('/^\d{1,2}$/', $infantWithoutMBNum)) {
            parent::set('infantWithoutMBNum', $infantWithoutMBNum);
        } else {
            trigger_error("[SyL error] Invalid `infantWithoutMBNum' property ({$infantWithoutMBNum}) in `" . __CLASS__ . "' class", E_USER_ERROR);
        }
    }

    /**
     * 򥻥åȤ
     *
     * @access public
     * @param int 
     */
    function setRoomNum($roomNum)
    {
        if (preg_match('/^\d{1,3}$/', $roomNum)) {
            parent::set('roomNum', $roomNum);
        } else {
            trigger_error("[SyL error] Invalid `roomNum' property ({$roomNum}) in `" . __CLASS__ . "' class", E_USER_ERROR);
        }
    }

    /**
     * ¶ۤ򥻥åȤ
     *
     * @access public
     * @param int ¶
     */
    function setMaxCharge($maxCharge)
    {
        if (preg_match('/^\d{1,10}$/', $maxCharge)) {
            parent::set('maxCharge', $maxCharge);
        } else {
            trigger_error("[SyL error] Invalid `maxCharge' property ({$maxCharge}) in `" . __CLASS__ . "' class", E_USER_ERROR);
        }
    }

    /**
     * ¶ۤ򥻥åȤ
     *
     * @access public
     * @param int ¶
     */
    function setMinCharge($minCharge)
    {
        if (preg_match('/^\d{1,10}$/', $minCharge)) {
            parent::set('minCharge', $minCharge);
        } else {
            trigger_error("[SyL error] Invalid `minCharge' property ({$minCharge}) in `" . __CLASS__ . "' class", E_USER_ERROR);
        }
    }

    /**
     * ٤򥻥åȤ
     *
     * @access public
     * @param int 
     */
    function setLatitude($latitude)
    {
        if (preg_match('/^\d+(\.\d+)?$/', $latitude)) {
            parent::set('latitude', $latitude);
        } else {
            trigger_error("[SyL error] Invalid `latitude' property ({$latitude}) in `" . __CLASS__ . "' class", E_USER_ERROR);
        }
    }

    /**
     * ٤򥻥åȤ
     *
     * @access public
     * @param int 
     */
    function setLongitude($longitude)
    {
        if (preg_match('/^\d+(\.\d+)?$/', $longitude)) {
            parent::set('longitude', $longitude);
        } else {
            trigger_error("[SyL error] Invalid `longitude' property ({$longitude}) in `" . __CLASS__ . "' class", E_USER_ERROR);
        }
    }

    /**
     * Ⱦ¤򥻥åȤ
     *
     * @access public
     * @param int Ⱦ (0.1ʾ塢3.0ʲ)
     */
    function setSearchRadius($searchRadius)
    {
        if (preg_match('/^\d(\.\d)?$/', $searchRadius) && ((float)$searchRadius >= 0.1) && ((float)$searchRadius <= 3.0)) {
            parent::set('searchRadius', $searchRadius);
        } else {
            trigger_error("[SyL error] Invalid `searchRadius' property ({$searchRadius}) in `" . __CLASS__ . "' class", E_USER_ERROR);
        }
    }

    /**
     * ʹ߾򥻥åȤ
     *
     * @access public
     * @param string ʹ߾
     */
    function setSqueezeCondition($squeezeCondition)
    {
        foreach (explode(',', $squeezeCondition) as $tmp) {
            switch ($tmp) {
            case 'kinen':
            case 'internet':
            case 'daiyoku':
            case 'onsen':
            case 'breakfast':
            case 'dinner':
                break;
            default:
                trigger_error("[SyL error] Invalid `squeezeCondition' property ({$squeezeCondition}) in `" . __CLASS__ . "' class", E_USER_ERROR);
            }
        }
        parent::set('squeezeCondition', $squeezeCondition);
    }

    /**
     * ꥢ򥻥åȤ
     *
     * @access public
     * @param int ꥢ
     */
    function setCarrier($carrier)
    {
        switch ((string)$carrier) {
        case '0':
        case '1':
            parent::set('carrier', $carrier);
            break;
        default:
            trigger_error("[SyL error] Invalid `carrier' property ({$carrier}) in `" . __CLASS__ . "' class", E_USER_ERROR);
        }
    }

    /**
     * ٷ٥פ򥻥åȤ
     *
     * @access public
     * @param int  ٷ٥
     */
    function setDatumType($datumType)
    {
        switch ((string)$datumType) {
        case '1': // ¬Ϸϡñ̤
        case '2': // ¬Ϸϡñ̤
            parent::set('datumType', $datumType);
            break;
        default:
            trigger_error("[SyL error] Invalid `datumType' property ({$datumType}) in `" . __CLASS__ . "' class", E_USER_ERROR);
        }
    }

    /**
     * 򥻥åȤ
     *
     * @access public
     * @param int 
     */
    function setHits($hits)
    {
        if (preg_match('/^\d+$/', $hits)) {
            parent::set('hits', $hits);
        } else {
            trigger_error("[SyL error] Invalid `hits' property ({$hits}) in `" . __CLASS__ . "' class", E_USER_ERROR);
        }
    }
}

?>
