<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2008 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_WebServiceMarketCatalogSearchResponse.php,v 1.1 2008/03/01 05:01:22 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * WEBӥ쥹ݥ󥹥饹ʳŷ - ŷAPIѡ
 *
 * ܺ٤ϡŷ֥ӥ󥿡
 *   http://webservice.rakuten.co.jp/
 * ŷAPI 
 *   http://webservice.rakuten.co.jp/api/catalogsearch/
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_WebServiceMarketCatalogSearchResponse.php,v 1.1 2008/03/01 05:01:22 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_WebServiceMarketCatalogSearchResponse extends SyL_WebServiceRakuten_co_jpResponse
{
    /**
     * 
     *
     * @access private
     * @var int
     */
    var $count = 0;
    /**
     * ڡֹ
     *
     * @access private
     * @var int
     */
    var $page = 0;
    /**
     * ڡ⾦ʻ
     *
     * @access private
     * @var int
     */
    var $first = 0;
    /**
     * ڡ⾦ʽ
     *
     * @access private
     * @var int
     */
    var $last = 0;
    /**
     * ҥåȷ
     *
     * @access private
     * @var int
     */
    var $hits = 0;
    /**
     * ꥢ
     *
     * @access private
     * @var int
     */
    var $carrier = 0;
    /**
     * ڡ
     *
     * @access private
     * @var int
     */
    var $page_count = 0;
    /**
     * 
     *
     * @access private
     * @var array
     */
    var $catalogs = array();
    /**
     * 
     *
     * @access private
     * @var array
     */
    var $current_genre = array();
    /**
     * ҥ
     *
     * @access private
     * @var array
     */
    var $child_genres = array();

    /**
     * XMLǡƼϥɥ᥽å
     *
     * @access protected
     * @param string XMLΥѥ
     * @param string XMLΥ°
     * @param string XMLΥ
     */
    function getElement($current_path, $attribute, $text)
    {
        static $i = -1;
        static $j = -1;

        switch ($current_path) {
        // =============================
        // 
        // =============================
        // 
        case '/Response/Body/catalogSearch:CatalogSearch/count': $this->count = $text; break;
        // ڡֹ
        case '/Response/Body/catalogSearch:CatalogSearch/page': $this->page = $text; break;
        // ڡ⾦ʻ
        case '/Response/Body/catalogSearch:CatalogSearch/first': $this->first = $text; break;
        // ڡ⾦ʽ
        case '/Response/Body/catalogSearch:CatalogSearch/last': $this->last = $text; break;
        // ҥåȷ
        case '/Response/Body/catalogSearch:CatalogSearch/hits': $this->hits = $text; break;
        // ꥢ
        case '/Response/Body/catalogSearch:CatalogSearch/carrier': $this->carrier = $text; break;
        // ڡ
        case '/Response/Body/catalogSearch:CatalogSearch/pageCount': $this->page_count = $text; break;

        case '/Response/Body/catalogSearch:CatalogSearch/Catalogs/Catalog': $i++; break;
        // ̾
        case '/Response/Body/catalogSearch:CatalogSearch/Catalogs/Catalog/catalogName': $this->catalogs[$i]['catalogName'] = $text; break;
        // 
        case '/Response/Body/catalogSearch:CatalogSearch/Catalogs/Catalog/catalogCode': $this->catalogs[$i]['catalogCode'] = $text; break;
        // 
        case '/Response/Body/catalogSearch:CatalogSearch/Catalogs/Catalog/modelNo': $this->catalogs[$i]['modelNo'] = $text; break;
        // ᡼̾
        case '/Response/Body/catalogSearch:CatalogSearch/Catalogs/Catalog/makerName': $this->catalogs[$i]['makerName'] = $text; break;
        // ꡼̾
        case '/Response/Body/catalogSearch:CatalogSearch/Catalogs/Catalog/seriesName': $this->catalogs[$i]['seriesName'] = $text; break;
        // ȯ
        case '/Response/Body/catalogSearch:CatalogSearch/Catalogs/Catalog/onSaleDate': $this->catalogs[$i]['onSaleDate'] = $text; break;
        // ɸ
        case '/Response/Body/catalogSearch:CatalogSearch/Catalogs/Catalog/catalogPrice': $this->catalogs[$i]['catalogPrice'] = $text; break;
        // ʸ
        case '/Response/Body/catalogSearch:CatalogSearch/Catalogs/Catalog/catalogCaption': $this->catalogs[$i]['catalogCaption'] = $text; break;
        // URL
        case '/Response/Body/catalogSearch:CatalogSearch/Catalogs/Catalog/catalogUrl': $this->catalogs[$i]['catalogUrl'] = $text; break;
        // ̵ͭե饰
        case '/Response/Body/catalogSearch:CatalogSearch/Catalogs/Catalog/imageFlag': $this->catalogs[$i]['imageFlag'] = $text; break;
        // 64x64URL
        case '/Response/Body/catalogSearch:CatalogSearch/Catalogs/Catalog/smallImageUrl': $this->catalogs[$i]['smallImageUrl'] = $text; break;
        // 128x128URL
        case '/Response/Body/catalogSearch:CatalogSearch/Catalogs/Catalog/mediumImageUrl': $this->catalogs[$i]['mediumImageUrl'] = $text; break;
        // ӥ塼
        case '/Response/Body/catalogSearch:CatalogSearch/Catalogs/Catalog/reviewCount': $this->catalogs[$i]['reviewCount'] = $text; break;
        // ȯ
        case '/Response/Body/catalogSearch:CatalogSearch/Catalogs/Catalog/onSaleDate': $this->catalogs[$i]['onSaleDate'] = $text; break;
        // °ID
        case '/Response/Body/catalogSearch:CatalogSearch/Catalogs/Catalog/genreId': $this->catalogs[$i]['genreId'] = $text; break;

        // : ID
        case '/Response/Body/catalogSearch:CatalogSearch/GenreInformation/current/genreId': $this->current_genre['genreId'] = $text; break;
        // : ̾
        case '/Response/Body/catalogSearch:CatalogSearch/GenreInformation/current/genreName': $this->current_genre['genreName'] = $text; break;
        // : ɳŤʿ
        case '/Response/Body/catalogSearch:CatalogSearch/GenreInformation/current/itemCount': $this->current_genre['itemCount'] = $text; break;
        // : 볬
        case '/Response/Body/catalogSearch:CatalogSearch/GenreInformation/current/genreLevel': $this->current_genre['genreLevel'] = $text; break;

        case '/Response/Body/catalogSearch:CatalogSearch/GenreInformation/child': $j++; break;
        // ҥ: ID
        case '/Response/Body/catalogSearch:CatalogSearch/GenreInformation/child/genreId': $this->child_genres[$j]['genreId'] = $text; break;
        // ҥ: ̾
        case '/Response/Body/catalogSearch:CatalogSearch/GenreInformation/child/genreName': $this->child_genres[$j]['genreName'] = $text; break;
        // ҥ: ɳŤʿ
        case '/Response/Body/catalogSearch:CatalogSearch/GenreInformation/child/itemCount': $this->child_genres[$j]['itemCount'] = $text; break;
        // ҥ: 볬
        case '/Response/Body/catalogSearch:CatalogSearch/GenreInformation/child/genreLevel': $this->child_genres[$j]['genreLevel'] = $text; break;

        // 嵭ʳ
        default: parent::getElement($current_path, $attribute, $text);
        }
    }

    /**
     * 
     *
     * @access public
     * @return int 
     */
    function getCount()
    {
        return $this->count;
    }

    /**
     * ڡֹ
     *
     * @access public
     * @return int 
     */
    function getPage()
    {
        return $this->page;
    }

    /**
     * ڡ⾦ʻ֤
     *
     * @access public
     * @return int 
     */
    function getFirst()
    {
        return $this->first;
    }

    /**
     * ڡ⾦ʽ֤
     *
     * @access public
     * @return int 
     */
    function getLast()
    {
        return $this->last;
    }

    /**
     * ꥢ
     *
     * @access public
     * @return int 
     */
    function getCarrier()
    {
        return $this->carrier;
    }

    /**
     * ڡ
     *
     * @access public
     * @return int 
     */
    function getPageCount()
    {
        return $this->page_count;
    }

    /**
     * 
     *
     * @access public
     * @return array 
     */
    function getCatalogs()
    {
        return $this->catalogs;
    }

    /**
     * 
     *
     * @access public
     * @param string ̾
     * @return mixed 
     */
    function getCurrentGenre($name=null)
    {
        if ($name !== null) {
            return isset($this->current_genre[$name]) ? $this->current_genre[$name] : null;
        } else {
            return $this->current_genre;
        }
    }

    /**
     * ҥ
     *
     * @access public
     * @return array ҥ
     */
    function getChildGenres()
    {
        return $this->child_genres;
    }
}

?>
