<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2008 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_WebServiceWeatherRequest.php,v 1.1 2008/03/01 05:01:22 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * WEBӥ쥹ݥ󥹥饹ʤŷWebӥѡ
 */
require_once 'SyL_WebServiceWeatherResponse.php';

/**
 * WEBӥꥯȥ饹ʤŷWebӥѡ
 *
 * ܺ٤ϡWeather Hacksʵݥǡۿӥ˻
 *   http://weather.livedoor.com/weather_hacks/
 * ŷWebӥ
 *   http://weather.livedoor.com/weather_hacks/webservice.html
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_WebServiceWeatherRequest.php,v 1.1 2008/03/01 05:01:22 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_WebServiceWeatherRequest extends SyL_WebServiceLivedoor_comRequest
{
    /**
     * WEBӥСΥۥ̾
     *
     * @access protected
     * @var string
     */
    var $host = 'weather.livedoor.com';
    /**
     * ¹URLѥ
     *
     * @access protected
     * @var string
     */
    var $path = '/forecast/webservice/rest/v1';
    /**
     * 쥹ݥ󥹥饹̾
     *
     * @access protected
     * @var string
     */
    var $response_class = 'SyL_WebServiceWeatherResponse';

    /**
     * ϰ̤줿IDֹ򥻥åȤ
     *
     * @access public
     * @param string ϰ̤줿IDֹ
     */
    function setCity($city)
    {
        if (preg_match('/^\d+$/', $city)) {
            parent::set('city', $city);
        } else {
            trigger_error("[SyL error] Invalid `city' property ({$city}) in `" . __CLASS__ . "' class", E_USER_ERROR);
        }
    }

    /**
     * ꥯȤͽ򥻥åȤ
     *
     * @access public
     * @param string ꥯȤͽ
     */
    function setDay($day)
    {
        switch ($day) {
        case 'today':
        case 'tomorrow':
        case 'dayaftertomorrow':
            parent::set('day', $day);
            break;
        default:
            trigger_error("[SyL error] Invalid `day' property ({$day}) in `" . __CLASS__ . "' class", E_USER_ERROR);
        }
    }
}

?>
