<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2008 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_WebServiceZipsearchResponse.php,v 1.1 2008/03/01 05:01:22 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * WEBӥ쥹ݥ󥹥饹͹ֹ渡APIѡ
 *
 * ܺ٤ϡWeb ӥ
 *   http://groovetechnology.co.jp/webservice/index.html
 * ͹ֹ渡API
 *   http://groovetechnology.co.jp/webservice/zipsearch/index.html
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_WebServiceZipsearchResponse.php,v 1.1 2008/03/01 05:01:22 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_WebServiceZipsearchResponse extends SyL_WebServiceGroovetechnology_co_jpResponse
{
    /**
     * ͹ֹ
     *
     * @access private
     * @var array
     */
    var $addresses = array();
    /**
     * Ƚθ͹ֹ
     *
     * @access private
     * @var array
     */
    var $offices = array();

    /**
     * XMLǡƼϥɥ᥽å
     *
     * @access protected
     * @param string XMLΥѥ
     * @param string XMLΥ°
     * @param string XMLΥ
     */
    function getElement($current_path, $attribute, $text)
    {
        static $a_i = -1;
        static $o_i = -1;

        switch ($current_path) {
        // =============================
        // 
        // =============================
        // ͹ֹξ
        case '/groovewebservice/address': $a_i++; break;
        // ͹ֹ
        case '/groovewebservice/address/zipcode': $this->addresses[$a_i]['zipcode'] = $text; break;
        // ƻܸ̾
        case '/groovewebservice/address/prefecture': $this->addresses[$a_i]['prefecture'] = $text; break;
        // ԶĮ¼̾
        case '/groovewebservice/address/city': $this->addresses[$a_i]['city'] = $text; break;
        // Į̾
        case '/groovewebservice/address/town': $this->addresses[$a_i]['town'] = $text; break;
        // Ƚ̾
        case '/groovewebservice/address/office_name': $this->addresses[$a_i]['office_name'] = $text; break;
        // Ƚ̾ξ̾ܡ
        case '/groovewebservice/address/street': $this->addresses[$a_i]['street'] = $text; break;
        // ƻܸ̾Τߡʥʡ
        case '/groovewebservice/address/prefecture_yomi': $this->addresses[$a_i]['prefecture_yomi'] = $text; break;
        // ԶĮ¼̾Τߡʥʡ
        case '/groovewebservice/address/city_yomi': $this->addresses[$a_i]['city_yomi'] = $text; break;
        // Į̾Τߡʥʡ
        case '/groovewebservice/address/town_yomi': $this->addresses[$a_i]['town_yomi'] = $text; break;
        // Ƚ̾Τߡʥʡ
        case '/groovewebservice/address/office_name_yomi': $this->addresses[$a_i]['town_yomi'] = $text; break;

        // Ƚθ͹ֹξ
        case '/groovewebservice/office': $o_i++; break;
        // ͹ֹ
        case '/groovewebservice/office/zipcode': $this->offices[$o_i]['zipcode'] = $text; break;
        // ƻܸ̾
        case '/groovewebservice/office/prefecture': $this->offices[$o_i]['prefecture'] = $text; break;
        // ԶĮ¼̾
        case '/groovewebservice/office/city': $this->offices[$o_i]['city'] = $text; break;
        // Į̾
        case '/groovewebservice/office/town': $this->offices[$o_i]['town'] = $text; break;
        // Ƚ̾
        case '/groovewebservice/office/office_name': $this->offices[$o_i]['office_name'] = $text; break;
        // Ƚ̾ξ̾ܡ
        case '/groovewebservice/office/street': $this->offices[$o_i]['street'] = $text; break;
        // ƻܸ̾Τߡʥʡ
        case '/groovewebservice/office/prefecture_yomi': $this->offices[$o_i]['prefecture_yomi'] = $text; break;
        // ԶĮ¼̾Τߡʥʡ
        case '/groovewebservice/office/city_yomi': $this->offices[$o_i]['city_yomi'] = $text; break;
        // Į̾Τߡʥʡ
        case '/groovewebservice/office/town_yomi': $this->offices[$o_i]['town_yomi'] = $text; break;
        // Ƚ̾Τߡʥʡ
        case '/groovewebservice/office/office_name_yomi': $this->offices[$o_i]['town_yomi'] = $text; break;

        }
    }

    /**
     * ͹ֹ
     *
     * @access public
     * @return array ͹ֹ
     */
    function getAddresses()
    {
        return $this->addresses;
    }

    /**
     * Ƚθ͹ֹ
     *
     * @access public
     * @return array Ƚθ͹ֹ
     */
    function getOffices()
    {
        return $this->offices;
    }
}

?>
